/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.webforms.model;

import com.docusign.webforms.model.TemplateProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Schema(description="Container for the components map used during configuration and data collection")
public class WebFormContent
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="components")
    private Map<String, Map<String, Object>> components = null;
    @JsonProperty(value="isStandalone")
    private Boolean isStandalone = null;
    @JsonProperty(value="brandId")
    private String brandId = null;
    @JsonProperty(value="templates")
    private List<TemplateProperties> templates = null;

    public WebFormContent components(Map<String, Map<String, Object>> components) {
        this.components = components;
        return this;
    }

    public WebFormContent putComponentsItem(String key, Map<String, Object> componentsItem) {
        if (this.components == null) {
            this.components = new HashMap<String, Map<String, Object>>();
        }
        this.components.put(key, componentsItem);
        return this;
    }

    @Schema(example="{\"Root_Of_Journey\":{\"componentKey\":\"Root_Of_Journey\",\"componentType\":\"Root\",\"children\":[\"Step_abc123\"]},\"TextBox_ABC123\":{\"componentKey\":\"TextBox_ABC123\",\"componentType\":\"TextBox\",\"componentName\":\"Full_Name\",\"label\":\"Full Name\",\"maxLength\":100,\"multiLine\":false,\"placeholder\":\"John Adams\",\"required\":true},\"Step_abc123\":{\"componentKey\":\"Step_abc123\",\"componentType\":\"Step\",\"componentName\":\"Step_abc123\",\"text\":\"Patient Demographics\"}}", description="Key/value dictionary of components that represent the form")
    public Map<String, Map<String, Object>> getComponents() {
        return this.components;
    }

    public void setComponents(Map<String, Map<String, Object>> components) {
        this.components = components;
    }

    public WebFormContent isStandalone(Boolean isStandalone) {
        this.isStandalone = isStandalone;
        return this;
    }

    @Schema(description="")
    public Boolean getIsStandalone() {
        return this.isStandalone;
    }

    public void setIsStandalone(Boolean isStandalone) {
        this.isStandalone = isStandalone;
    }

    public WebFormContent brandId(String brandId) {
        this.brandId = brandId;
        return this;
    }

    @Schema(description="")
    public String getBrandId() {
        return this.brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public WebFormContent templates(List<TemplateProperties> templates) {
        this.templates = templates;
        return this;
    }

    public WebFormContent addTemplatesItem(TemplateProperties templatesItem) {
        if (this.templates == null) {
            this.templates = new ArrayList<TemplateProperties>();
        }
        this.templates.add(templatesItem);
        return this;
    }

    @Schema(description="Optional template information that will be used to seed the form.")
    public List<TemplateProperties> getTemplates() {
        return this.templates;
    }

    public void setTemplates(List<TemplateProperties> templates) {
        this.templates = templates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebFormContent webFormContent = (WebFormContent)o;
        return Objects.equals(this.components, webFormContent.components) && Objects.equals(this.isStandalone, webFormContent.isStandalone) && Objects.equals(this.brandId, webFormContent.brandId) && Objects.equals(this.templates, webFormContent.templates);
    }

    public int hashCode() {
        return Objects.hash(this.components, this.isStandalone, this.brandId, this.templates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebFormContent {\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("    isStandalone: ").append(this.toIndentedString(this.isStandalone)).append("\n");
        sb.append("    brandId: ").append(this.toIndentedString(this.brandId)).append("\n");
        sb.append("    templates: ").append(this.toIndentedString(this.templates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

