/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.file;

import com.box.sdkgen.internal.Nullable;
import com.box.sdkgen.internal.utils.DateTimeUtils;
import com.box.sdkgen.schemas.file.FileItemStatusField;
import com.box.sdkgen.schemas.file.FilePathCollectionField;
import com.box.sdkgen.schemas.file.FileSharedLinkField;
import com.box.sdkgen.schemas.filebase.FileBaseTypeField;
import com.box.sdkgen.schemas.filemini.FileMini;
import com.box.sdkgen.schemas.fileversionmini.FileVersionMini;
import com.box.sdkgen.schemas.foldermini.FolderMini;
import com.box.sdkgen.schemas.usermini.UserMini;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class File
extends FileMini {
    protected String description;
    protected Long size;
    @JsonProperty(value="path_collection")
    protected FilePathCollectionField pathCollection;
    @JsonProperty(value="created_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime createdAt;
    @JsonProperty(value="modified_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime modifiedAt;
    @JsonProperty(value="trashed_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    @Nullable
    protected OffsetDateTime trashedAt;
    @JsonProperty(value="purged_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    @Nullable
    protected OffsetDateTime purgedAt;
    @JsonProperty(value="content_created_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    @Nullable
    protected OffsetDateTime contentCreatedAt;
    @JsonProperty(value="content_modified_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    @Nullable
    protected OffsetDateTime contentModifiedAt;
    @JsonProperty(value="created_by")
    protected UserMini createdBy;
    @JsonProperty(value="modified_by")
    protected UserMini modifiedBy;
    @JsonProperty(value="owned_by")
    protected UserMini ownedBy;
    @JsonProperty(value="shared_link")
    protected FileSharedLinkField sharedLink;
    @Nullable
    protected FolderMini parent;
    @JsonDeserialize(using=FileItemStatusField.FileItemStatusFieldDeserializer.class)
    @JsonSerialize(using=FileItemStatusField.FileItemStatusFieldSerializer.class)
    @JsonProperty(value="item_status")
    protected EnumWrapper<FileItemStatusField> itemStatus;

    public File(@JsonProperty(value="id") String id) {
        super(id);
    }

    protected File(Builder builder) {
        super(builder);
        this.description = builder.description;
        this.size = builder.size;
        this.pathCollection = builder.pathCollection;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.trashedAt = builder.trashedAt;
        this.purgedAt = builder.purgedAt;
        this.contentCreatedAt = builder.contentCreatedAt;
        this.contentModifiedAt = builder.contentModifiedAt;
        this.createdBy = builder.createdBy;
        this.modifiedBy = builder.modifiedBy;
        this.ownedBy = builder.ownedBy;
        this.sharedLink = builder.sharedLink;
        this.parent = builder.parent;
        this.itemStatus = builder.itemStatus;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public String getDescription() {
        return this.description;
    }

    public Long getSize() {
        return this.size;
    }

    public FilePathCollectionField getPathCollection() {
        return this.pathCollection;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public OffsetDateTime getTrashedAt() {
        return this.trashedAt;
    }

    public OffsetDateTime getPurgedAt() {
        return this.purgedAt;
    }

    public OffsetDateTime getContentCreatedAt() {
        return this.contentCreatedAt;
    }

    public OffsetDateTime getContentModifiedAt() {
        return this.contentModifiedAt;
    }

    public UserMini getCreatedBy() {
        return this.createdBy;
    }

    public UserMini getModifiedBy() {
        return this.modifiedBy;
    }

    public UserMini getOwnedBy() {
        return this.ownedBy;
    }

    public FileSharedLinkField getSharedLink() {
        return this.sharedLink;
    }

    public FolderMini getParent() {
        return this.parent;
    }

    public EnumWrapper<FileItemStatusField> getItemStatus() {
        return this.itemStatus;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        File casted = (File)o;
        return Objects.equals(this.id, casted.id) && Objects.equals(this.etag, casted.etag) && Objects.equals(this.type, casted.type) && Objects.equals(this.sequenceId, casted.sequenceId) && Objects.equals(this.name, casted.name) && Objects.equals(this.sha1, casted.sha1) && Objects.equals(this.fileVersion, casted.fileVersion) && Objects.equals(this.description, casted.description) && Objects.equals(this.size, casted.size) && Objects.equals(this.pathCollection, casted.pathCollection) && Objects.equals(this.createdAt, casted.createdAt) && Objects.equals(this.modifiedAt, casted.modifiedAt) && Objects.equals(this.trashedAt, casted.trashedAt) && Objects.equals(this.purgedAt, casted.purgedAt) && Objects.equals(this.contentCreatedAt, casted.contentCreatedAt) && Objects.equals(this.contentModifiedAt, casted.contentModifiedAt) && Objects.equals(this.createdBy, casted.createdBy) && Objects.equals(this.modifiedBy, casted.modifiedBy) && Objects.equals(this.ownedBy, casted.ownedBy) && Objects.equals(this.sharedLink, casted.sharedLink) && Objects.equals(this.parent, casted.parent) && Objects.equals(this.itemStatus, casted.itemStatus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.etag, this.type, this.sequenceId, this.name, this.sha1, this.fileVersion, this.description, this.size, this.pathCollection, this.createdAt, this.modifiedAt, this.trashedAt, this.purgedAt, this.contentCreatedAt, this.contentModifiedAt, this.createdBy, this.modifiedBy, this.ownedBy, this.sharedLink, this.parent, this.itemStatus);
    }

    @Override
    public String toString() {
        return "File{id='" + this.id + '\'' + ", etag='" + this.etag + '\'' + ", type='" + this.type + '\'' + ", sequenceId='" + this.sequenceId + '\'' + ", name='" + this.name + '\'' + ", sha1='" + this.sha1 + '\'' + ", fileVersion='" + this.fileVersion + '\'' + ", description='" + this.description + '\'' + ", size='" + this.size + '\'' + ", pathCollection='" + this.pathCollection + '\'' + ", createdAt='" + this.createdAt + '\'' + ", modifiedAt='" + this.modifiedAt + '\'' + ", trashedAt='" + this.trashedAt + '\'' + ", purgedAt='" + this.purgedAt + '\'' + ", contentCreatedAt='" + this.contentCreatedAt + '\'' + ", contentModifiedAt='" + this.contentModifiedAt + '\'' + ", createdBy='" + this.createdBy + '\'' + ", modifiedBy='" + this.modifiedBy + '\'' + ", ownedBy='" + this.ownedBy + '\'' + ", sharedLink='" + this.sharedLink + '\'' + ", parent='" + this.parent + '\'' + ", itemStatus='" + this.itemStatus + '\'' + "}";
    }

    public static class Builder
    extends FileMini.Builder {
        protected String description;
        protected Long size;
        protected FilePathCollectionField pathCollection;
        protected OffsetDateTime createdAt;
        protected OffsetDateTime modifiedAt;
        protected OffsetDateTime trashedAt;
        protected OffsetDateTime purgedAt;
        protected OffsetDateTime contentCreatedAt;
        protected OffsetDateTime contentModifiedAt;
        protected UserMini createdBy;
        protected UserMini modifiedBy;
        protected UserMini ownedBy;
        protected FileSharedLinkField sharedLink;
        protected FolderMini parent;
        protected EnumWrapper<FileItemStatusField> itemStatus;

        public Builder(String id) {
            super(id);
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            return this;
        }

        public Builder pathCollection(FilePathCollectionField pathCollection) {
            this.pathCollection = pathCollection;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder trashedAt(OffsetDateTime trashedAt) {
            this.trashedAt = trashedAt;
            this.markNullableFieldAsSet("trashed_at");
            return this;
        }

        public Builder purgedAt(OffsetDateTime purgedAt) {
            this.purgedAt = purgedAt;
            this.markNullableFieldAsSet("purged_at");
            return this;
        }

        public Builder contentCreatedAt(OffsetDateTime contentCreatedAt) {
            this.contentCreatedAt = contentCreatedAt;
            this.markNullableFieldAsSet("content_created_at");
            return this;
        }

        public Builder contentModifiedAt(OffsetDateTime contentModifiedAt) {
            this.contentModifiedAt = contentModifiedAt;
            this.markNullableFieldAsSet("content_modified_at");
            return this;
        }

        public Builder createdBy(UserMini createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder modifiedBy(UserMini modifiedBy) {
            this.modifiedBy = modifiedBy;
            return this;
        }

        public Builder ownedBy(UserMini ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public Builder sharedLink(FileSharedLinkField sharedLink) {
            this.sharedLink = sharedLink;
            return this;
        }

        public Builder parent(FolderMini parent) {
            this.parent = parent;
            this.markNullableFieldAsSet("parent");
            return this;
        }

        public Builder itemStatus(FileItemStatusField itemStatus) {
            this.itemStatus = new EnumWrapper<FileItemStatusField>(itemStatus);
            return this;
        }

        public Builder itemStatus(EnumWrapper<FileItemStatusField> itemStatus) {
            this.itemStatus = itemStatus;
            return this;
        }

        @Override
        public Builder etag(String etag) {
            this.etag = etag;
            this.markNullableFieldAsSet("etag");
            return this;
        }

        @Override
        public Builder type(FileBaseTypeField type) {
            this.type = new EnumWrapper<FileBaseTypeField>(type);
            return this;
        }

        @Override
        public Builder type(EnumWrapper<FileBaseTypeField> type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder sequenceId(String sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder sha1(String sha1) {
            this.sha1 = sha1;
            return this;
        }

        @Override
        public Builder fileVersion(FileVersionMini fileVersion) {
            this.fileVersion = fileVersion;
            return this;
        }

        @Override
        public File build() {
            return new File(this);
        }
    }
}

