/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.models;

import com.azure.core.util.CoreUtils;
import com.azure.data.tables.models.TableServiceCorsRule;
import com.azure.data.tables.models.TableServiceLogging;
import com.azure.data.tables.models.TableServiceMetrics;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class TableServiceProperties
implements XmlSerializable<TableServiceProperties> {
    private TableServiceLogging logging;
    private TableServiceMetrics hourMetrics;
    private TableServiceMetrics minuteMetrics;
    private List<TableServiceCorsRule> cors;

    public TableServiceLogging getLogging() {
        return this.logging;
    }

    public TableServiceProperties setLogging(TableServiceLogging logging) {
        this.logging = logging;
        return this;
    }

    public TableServiceMetrics getHourMetrics() {
        return this.hourMetrics;
    }

    public TableServiceProperties setHourMetrics(TableServiceMetrics hourMetrics) {
        this.hourMetrics = hourMetrics;
        return this;
    }

    public TableServiceMetrics getMinuteMetrics() {
        return this.minuteMetrics;
    }

    public TableServiceProperties setMinuteMetrics(TableServiceMetrics minuteMetrics) {
        this.minuteMetrics = minuteMetrics;
        return this;
    }

    public List<TableServiceCorsRule> getCorsRules() {
        return this.cors;
    }

    public TableServiceProperties setCorsRules(List<TableServiceCorsRule> cors) {
        this.cors = cors;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "StorageServiceProperties" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml((XmlSerializable)this.logging, "Logging");
        xmlWriter.writeXml((XmlSerializable)this.hourMetrics, "HourMetrics");
        xmlWriter.writeXml((XmlSerializable)this.minuteMetrics, "MinuteMetrics");
        if (this.cors != null) {
            xmlWriter.writeStartElement("Cors");
            for (TableServiceCorsRule element : this.cors) {
                xmlWriter.writeXml((XmlSerializable)element, "CorsRule");
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    public static TableServiceProperties fromXml(XmlReader xmlReader) throws XMLStreamException {
        return TableServiceProperties.fromXml(xmlReader, null);
    }

    public static TableServiceProperties fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "StorageServiceProperties" : rootElementName;
        return (TableServiceProperties)xmlReader.readObject(finalRootElementName, reader -> {
            TableServiceProperties deserializedTableServiceProperties = new TableServiceProperties();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Logging".equals(elementName.getLocalPart())) {
                    deserializedTableServiceProperties.logging = TableServiceLogging.fromXml(reader, "Logging");
                    continue;
                }
                if ("HourMetrics".equals(elementName.getLocalPart())) {
                    deserializedTableServiceProperties.hourMetrics = TableServiceMetrics.fromXml(reader, "HourMetrics");
                    continue;
                }
                if ("MinuteMetrics".equals(elementName.getLocalPart())) {
                    deserializedTableServiceProperties.minuteMetrics = TableServiceMetrics.fromXml(reader, "MinuteMetrics");
                    continue;
                }
                if ("Cors".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("CorsRule".equals(elementName.getLocalPart())) {
                            if (deserializedTableServiceProperties.cors == null) {
                                deserializedTableServiceProperties.cors = new ArrayList<TableServiceCorsRule>();
                            }
                            deserializedTableServiceProperties.cors.add(TableServiceCorsRule.fromXml(reader, "CorsRule"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                reader.skipElement();
            }
            return deserializedTableServiceProperties;
        });
    }
}

