/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation;

import com.azure.ai.openai.models.NonAzureOpenAIKeyCredential;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class NonAzureOpenAIKeyCredentialPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(NonAzureOpenAIKeyCredentialPolicy.class);
    private final HttpHeaderName name;
    private final NonAzureOpenAIKeyCredential credential;
    private final String prefix;

    public NonAzureOpenAIKeyCredentialPolicy(String name, NonAzureOpenAIKeyCredential credential, String prefix) {
        this.name = NonAzureOpenAIKeyCredentialPolicy.validateName(name);
        this.credential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.prefix = prefix != null ? prefix.trim() : null;
    }

    private static HttpHeaderName validateName(String name) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        if (name.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'name' cannot be empty."));
        }
        return HttpHeaderName.fromString((String)name);
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if ("http".equals(context.getHttpRequest().getUrl().getProtocol())) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalStateException("Key credentials require HTTPS to prevent leaking the key."));
        }
        this.setCredential(context.getHttpRequest().getHeaders());
        return next.process();
    }

    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        if ("http".equals(context.getHttpRequest().getUrl().getProtocol())) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Key credentials require HTTPS to prevent leaking the key."));
        }
        this.setCredential(context.getHttpRequest().getHeaders());
        return next.processSync();
    }

    void setCredential(HttpHeaders headers) {
        String credential = this.credential.getKey();
        headers.set(this.name, this.prefix == null ? credential : this.prefix + " " + credential);
    }
}

