/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.WeakHashMap;

public class TypoLookup {
    private static final TypoLookup NONE = new TypoLookup();
    private static final String WORD_SEPARATOR = "->";
    private static final String XML_FILE_PATH = "tools/support/typos-%1$s.txt";
    private static final String FILE_HEADER = "Typo database used by Android lint\u0000";
    private static final int BINARY_FORMAT_VERSION = 2;
    private static final boolean DEBUG_FORCE_REGENERATE_BINARY = false;
    private static final boolean DEBUG_SEARCH = false;
    private static final boolean WRITE_STATS = false;
    private static final int BYTES_PER_ENTRY = 28;
    private final LintClient mClient;
    private final File mXmlFile;
    private final File mBinaryFile;
    private byte[] mData;
    private int[] mIndices;
    private int mWordCount;
    private static final WeakHashMap<String, TypoLookup> sInstanceMap = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static TypoLookup get(@NonNull LintClient client, @NonNull String locale, @Nullable String region) {
        Class<TypoLookup> clazz = TypoLookup.class;
        synchronized (TypoLookup.class) {
            TypoLookup db;
            String key = locale;
            if (region != null) {
                assert (region.length() == 2 && Character.isUpperCase(region.charAt(0)) && Character.isUpperCase(region.charAt(1))) : region;
                key = locale + 'r' + region;
            }
            if ((db = sInstanceMap.get(key)) == null) {
                String build;
                String path = String.format(XML_FILE_PATH, key);
                File file = client.findResource(path);
                if (file == null && (build = System.getenv("ANDROID_BUILD_TOP")) != null) {
                    file = new File(build, ("sdk/files/" + path.substring(path.lastIndexOf(47) + 1)).replace('/', File.separatorChar));
                }
                if (file == null || !file.exists()) {
                    if (region != null) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return TypoLookup.get(client, locale, null);
                    }
                    db = NONE;
                } else {
                    db = TypoLookup.get(client, file);
                    assert (db != null) : file;
                }
                sInstanceMap.put(key, db);
            }
            if (db == NONE) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return db;
        }
    }

    @Nullable
    private static TypoLookup get(LintClient client, File xmlFile) {
        File binaryData;
        File cacheDir;
        if (!xmlFile.exists()) {
            client.log(null, "The typo database file %1$s does not exist", new Object[]{xmlFile});
            return null;
        }
        String name = xmlFile.getName();
        if (LintUtils.endsWith((String)name, (String)".xml")) {
            name = name.substring(0, name.length() - ".xml".length());
        }
        if ((cacheDir = client.getCacheDir(true)) == null) {
            cacheDir = xmlFile.getParentFile();
        }
        if (!((binaryData = new File(cacheDir, name + '-' + 2 + ".bin")).exists() && binaryData.lastModified() >= xmlFile.lastModified() || TypoLookup.createCache(client, xmlFile, binaryData))) {
            return null;
        }
        if (!binaryData.exists()) {
            client.log(null, "The typo database file %1$s does not exist", new Object[]{binaryData});
            return null;
        }
        return new TypoLookup(client, xmlFile, binaryData);
    }

    private static boolean createCache(LintClient client, File xmlFile, File binaryData) {
        List lines;
        long begin = 0L;
        try {
            lines = Files.readLines((File)xmlFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            client.log((Throwable)e, "Can't read typo database file", new Object[0]);
            return false;
        }
        try {
            TypoLookup.writeDatabase(binaryData, lines);
            return true;
        }
        catch (IOException ioe) {
            client.log((Throwable)ioe, "Can't write typo cache file", new Object[0]);
            return false;
        }
    }

    private TypoLookup(@NonNull LintClient client, @NonNull File xmlFile, @Nullable File binaryFile) {
        this.mClient = client;
        this.mXmlFile = xmlFile;
        this.mBinaryFile = binaryFile;
        if (binaryFile != null) {
            this.readData();
        }
    }

    private TypoLookup() {
        this.mClient = null;
        this.mXmlFile = null;
        this.mBinaryFile = null;
    }

    private void readData() {
        if (!this.mBinaryFile.exists()) {
            this.mClient.log(null, "%1$s does not exist", new Object[]{this.mBinaryFile});
            return;
        }
        long start = System.currentTimeMillis();
        try {
            MappedByteBuffer buffer = Files.map((File)this.mBinaryFile, (FileChannel.MapMode)FileChannel.MapMode.READ_ONLY);
            assert (buffer.order() == ByteOrder.BIG_ENDIAN);
            byte[] expectedHeader = FILE_HEADER.getBytes(Charsets.US_ASCII);
            buffer.rewind();
            for (int offset = 0; offset < expectedHeader.length; ++offset) {
                if (expectedHeader[offset] == buffer.get()) continue;
                this.mClient.log(null, "Incorrect file header: not an typo database cache file, or a corrupt cache file", new Object[0]);
                return;
            }
            if (buffer.get() != 2) {
                if (TypoLookup.createCache(this.mClient, this.mXmlFile, this.mBinaryFile)) {
                    this.readData();
                }
                return;
            }
            int count = this.mWordCount = buffer.getInt();
            int[] offsets = new int[count];
            for (int i = 0; i < count; ++i) {
                offsets[i] = buffer.getInt();
            }
            int size = buffer.limit();
            byte[] b = new byte[size];
            buffer.rewind();
            buffer.get(b);
            this.mData = b;
            this.mIndices = offsets;
        }
        catch (IOException e) {
            this.mClient.log((Throwable)e, null, new Object[0]);
        }
    }

    private static void writeDatabase(File file, List<String> lines) throws IOException {
        ArrayList<String> words = new ArrayList<String>(lines.size());
        for (String line : lines) {
            if (line.isEmpty() || !Character.isLetter(line.charAt(0))) continue;
            int end = line.indexOf(WORD_SEPARATOR);
            if (end == -1) {
                end = line.trim().length();
            }
            String typo = line.substring(0, end).trim();
            String replacements = line.substring(end + WORD_SEPARATOR.length()).trim();
            if (replacements.isEmpty()) continue;
            String combined = typo + '\u0000' + replacements;
            words.add(combined);
        }
        byte[][] wordArrays = new byte[words.size()][];
        int n = words.size();
        for (int i = 0; i < n; ++i) {
            String word = (String)words.get(i);
            wordArrays[i] = word.getBytes(Charsets.UTF_8);
        }
        Comparator<byte[]> comparator = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                return TypoLookup.compare(o1, 0, (byte)0, o2, 0, o2.length);
            }
        };
        Arrays.sort(wordArrays, comparator);
        int entryCount = wordArrays.length;
        int capacity = entryCount * 28;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.put(FILE_HEADER.getBytes(Charsets.US_ASCII));
        buffer.put((byte)2);
        buffer.putInt(entryCount);
        int wordOffsetTable = buffer.position();
        int n2 = entryCount;
        for (int i = 0; i < n2; ++i) {
            buffer.putInt(0);
        }
        int nextEntry = buffer.position();
        int nextOffset = wordOffsetTable;
        for (int i = 0; i < entryCount; ++i) {
            byte[] word = wordArrays[i];
            buffer.position(nextOffset);
            buffer.putInt(nextEntry);
            nextOffset = buffer.position();
            buffer.position(nextEntry);
            buffer.put(word);
            buffer.put((byte)0);
            nextEntry = buffer.position();
        }
        int size = buffer.position();
        assert (size <= buffer.limit());
        buffer.mark();
        byte[] b = new byte[size];
        buffer.rewind();
        buffer.get(b);
        FileOutputStream output = (FileOutputStream)Files.newOutputStreamSupplier((File)file).getOutput();
        output.write(b);
        output.close();
    }

    private String dumpEntry(int offset) {
        return "<disabled>";
    }

    static int compare(byte[] data, int offset, byte terminator, CharSequence s, int begin, int end) {
        int i = offset;
        int j = begin;
        while (true) {
            int max;
            byte b;
            if ((b = data[i]) == 32 && j == end && end < (max = s.length()) && s.charAt(end) == ' ') {
                char c;
                while (end < max && (Character.isLetter(c = s.charAt(end)) || c == ' ' && end == j)) {
                    ++end;
                }
            }
            if (j == end) break;
            if (b == 42) {
                return 0;
            }
            char c = s.charAt(j);
            byte cb = (byte)c;
            int delta = b - cb;
            if (delta != 0 && b != (cb = (byte)Character.toLowerCase(c)) && (delta = (b = (byte)Character.toLowerCase(b)) - cb) != 0) {
                return delta;
            }
            ++i;
            ++j;
        }
        return data[i] - terminator;
    }

    static int compare(byte[] data, int offset, byte terminator, byte[] s, int begin, int end) {
        int i = offset;
        int j = begin;
        while (true) {
            int max;
            byte b;
            if ((b = data[i]) == 32 && j == end && end < (max = s.length) && s[end] == 32) {
                byte cb;
                while (end < max && (TypoLookup.isLetter(cb = s[end]) || cb == 32 && end == j)) {
                    ++end;
                }
            }
            if (j == end) break;
            if (b == 42) {
                return 0;
            }
            byte cb = s[j];
            int delta = b - cb;
            if (delta != 0) {
                cb = TypoLookup.toLowerCase(cb);
                delta = (b = TypoLookup.toLowerCase(b)) - cb;
                if (delta != 0) {
                    return delta;
                }
            }
            if (b == terminator || cb == terminator) {
                return delta;
            }
            ++i;
            ++j;
        }
        return data[i] - terminator;
    }

    @Nullable
    public List<String> getTypos(@NonNull CharSequence text, int begin, int end) {
        assert (end <= text.length());
        if (LintUtils.assertionsEnabled()) {
            for (int i = begin; i < end; ++i) {
                char c = text.charAt(i);
                if (c < '\u0080') continue;
                assert (false) : "Call the UTF-8 version of this method instead";
                return null;
            }
        }
        int low = 0;
        int high = this.mWordCount - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            int offset = this.mIndices[middle];
            int compare = TypoLookup.compare(this.mData, offset, (byte)0, text, begin, end);
            if (compare == 0) {
                offset = this.mIndices[middle];
                if (this.mData[offset] != text.charAt(begin) && Character.isLowerCase(text.charAt(begin))) {
                    return null;
                }
                String glob = null;
                int i = begin;
                while (true) {
                    byte b;
                    if ((b = this.mData[offset++]) == 0) {
                        --offset;
                        break;
                    }
                    if (b == 42) {
                        int globEnd;
                        for (globEnd = i; globEnd < text.length() && Character.isLetter(text.charAt(globEnd)); ++globEnd) {
                        }
                        glob = ((Object)text.subSequence(i, globEnd)).toString();
                        break;
                    }
                    char c = text.charAt(i);
                    byte cb = (byte)c;
                    if (b != cb && i > begin) {
                        return null;
                    }
                    ++i;
                }
                return this.computeSuggestions(this.mIndices[middle], offset, glob);
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            if (compare > 0) {
                high = middle - 1;
                continue;
            }
            assert (false);
            return null;
        }
        return null;
    }

    @Nullable
    public List<String> getTypos(@NonNull byte[] utf8Text, int begin, int end) {
        assert (end <= utf8Text.length);
        int low = 0;
        int high = this.mWordCount - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            int offset = this.mIndices[middle];
            int compare = TypoLookup.compare(this.mData, offset, (byte)0, utf8Text, begin, end);
            if (compare == 0) {
                offset = this.mIndices[middle];
                if (this.mData[offset] != utf8Text[begin] && TypoLookup.isUpperCase(this.mData[offset])) {
                    return null;
                }
                String glob = null;
                int i = begin;
                while (true) {
                    byte b;
                    if ((b = this.mData[offset++]) == 0) {
                        --offset;
                        break;
                    }
                    if (b == 42) {
                        int globEnd;
                        for (globEnd = i; globEnd < utf8Text.length && TypoLookup.isLetter(utf8Text[globEnd]); ++globEnd) {
                        }
                        glob = new String(utf8Text, i, globEnd - i, Charsets.UTF_8);
                        break;
                    }
                    byte cb = utf8Text[i];
                    if (b != cb && i > begin) {
                        return null;
                    }
                    ++i;
                }
                return this.computeSuggestions(this.mIndices[middle], offset, glob);
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            if (compare > 0) {
                high = middle - 1;
                continue;
            }
            assert (false);
            return null;
        }
        return null;
    }

    private List<String> computeSuggestions(int begin, int offset, String glob) {
        String typo = new String(this.mData, begin, offset - begin, Charsets.UTF_8);
        if (glob != null) {
            typo = typo.replaceAll("\\*", glob);
        }
        assert (this.mData[offset] == 0);
        int replacementEnd = ++offset;
        while (this.mData[replacementEnd] != 0) {
            ++replacementEnd;
        }
        String replacements = new String(this.mData, offset, replacementEnd - offset, Charsets.UTF_8);
        ArrayList<String> words = new ArrayList<String>();
        words.add(typo);
        for (String s : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)replacements)) {
            if (glob != null) {
                words.add(s.replaceAll("\\*", glob));
                continue;
            }
            words.add(s);
        }
        return words;
    }

    static boolean isUpperCase(byte b) {
        return Character.isUpperCase((char)b);
    }

    static byte toLowerCase(byte b) {
        return (byte)Character.toLowerCase((char)b);
    }

    static boolean isSpace(byte b) {
        return Character.isWhitespace((char)b);
    }

    static boolean isLetter(byte b) {
        return Character.isLetter((char)b) || (b & 0x80) != 0;
    }
}

