/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspacesweb.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.workspacesweb.model.Certificate;
import java.nio.ByteBuffer;
import java.util.Date;

@SdkInternalApi
public class CertificateMarshaller {
    private static final MarshallingInfo<ByteBuffer> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("body").build();
    private static final MarshallingInfo<String> ISSUER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("issuer").build();
    private static final MarshallingInfo<Date> NOTVALIDAFTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("notValidAfter").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> NOTVALIDBEFORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("notValidBefore").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> SUBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subject").build();
    private static final MarshallingInfo<String> THUMBPRINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thumbprint").build();
    private static final CertificateMarshaller instance = new CertificateMarshaller();

    public static CertificateMarshaller getInstance() {
        return instance;
    }

    public void marshall(Certificate certificate, ProtocolMarshaller protocolMarshaller) {
        if (certificate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)certificate.getBody(), BODY_BINDING);
            protocolMarshaller.marshall((Object)certificate.getIssuer(), ISSUER_BINDING);
            protocolMarshaller.marshall((Object)certificate.getNotValidAfter(), NOTVALIDAFTER_BINDING);
            protocolMarshaller.marshall((Object)certificate.getNotValidBefore(), NOTVALIDBEFORE_BINDING);
            protocolMarshaller.marshall((Object)certificate.getSubject(), SUBJECT_BINDING);
            protocolMarshaller.marshall((Object)certificate.getThumbprint(), THUMBPRINT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

