/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.ShortFormatText;

@SdkInternalApi
public class ShortFormatTextMarshaller {
    private static final MarshallingInfo<String> PLAINTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlainText").build();
    private static final MarshallingInfo<String> RICHTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RichText").build();
    private static final ShortFormatTextMarshaller instance = new ShortFormatTextMarshaller();

    public static ShortFormatTextMarshaller getInstance() {
        return instance;
    }

    public void marshall(ShortFormatText shortFormatText, ProtocolMarshaller protocolMarshaller) {
        if (shortFormatText == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)shortFormatText.getPlainText(), PLAINTEXT_BINDING);
            protocolMarshaller.marshall((Object)shortFormatText.getRichText(), RICHTEXT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

