/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pipes.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pipes.model.SelfManagedKafkaAccessConfigurationCredentials;
import com.amazonaws.services.pipes.model.SelfManagedKafkaAccessConfigurationVpc;
import com.amazonaws.services.pipes.model.SelfManagedKafkaStartPosition;
import com.amazonaws.services.pipes.model.transform.PipeSourceSelfManagedKafkaParametersMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PipeSourceSelfManagedKafkaParameters
implements Serializable,
Cloneable,
StructuredPojo {
    private String topicName;
    private String startingPosition;
    private List<String> additionalBootstrapServers;
    private Integer batchSize;
    private Integer maximumBatchingWindowInSeconds;
    private String consumerGroupID;
    private SelfManagedKafkaAccessConfigurationCredentials credentials;
    private String serverRootCaCertificate;
    private SelfManagedKafkaAccessConfigurationVpc vpc;

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public PipeSourceSelfManagedKafkaParameters withTopicName(String topicName) {
        this.setTopicName(topicName);
        return this;
    }

    public void setStartingPosition(String startingPosition) {
        this.startingPosition = startingPosition;
    }

    public String getStartingPosition() {
        return this.startingPosition;
    }

    public PipeSourceSelfManagedKafkaParameters withStartingPosition(String startingPosition) {
        this.setStartingPosition(startingPosition);
        return this;
    }

    public PipeSourceSelfManagedKafkaParameters withStartingPosition(SelfManagedKafkaStartPosition startingPosition) {
        this.startingPosition = startingPosition.toString();
        return this;
    }

    public List<String> getAdditionalBootstrapServers() {
        return this.additionalBootstrapServers;
    }

    public void setAdditionalBootstrapServers(Collection<String> additionalBootstrapServers) {
        if (additionalBootstrapServers == null) {
            this.additionalBootstrapServers = null;
            return;
        }
        this.additionalBootstrapServers = new ArrayList<String>(additionalBootstrapServers);
    }

    public PipeSourceSelfManagedKafkaParameters withAdditionalBootstrapServers(String ... additionalBootstrapServers) {
        if (this.additionalBootstrapServers == null) {
            this.setAdditionalBootstrapServers(new ArrayList<String>(additionalBootstrapServers.length));
        }
        for (String ele : additionalBootstrapServers) {
            this.additionalBootstrapServers.add(ele);
        }
        return this;
    }

    public PipeSourceSelfManagedKafkaParameters withAdditionalBootstrapServers(Collection<String> additionalBootstrapServers) {
        this.setAdditionalBootstrapServers(additionalBootstrapServers);
        return this;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public PipeSourceSelfManagedKafkaParameters withBatchSize(Integer batchSize) {
        this.setBatchSize(batchSize);
        return this;
    }

    public void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
        this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
    }

    public Integer getMaximumBatchingWindowInSeconds() {
        return this.maximumBatchingWindowInSeconds;
    }

    public PipeSourceSelfManagedKafkaParameters withMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
        this.setMaximumBatchingWindowInSeconds(maximumBatchingWindowInSeconds);
        return this;
    }

    public void setConsumerGroupID(String consumerGroupID) {
        this.consumerGroupID = consumerGroupID;
    }

    public String getConsumerGroupID() {
        return this.consumerGroupID;
    }

    public PipeSourceSelfManagedKafkaParameters withConsumerGroupID(String consumerGroupID) {
        this.setConsumerGroupID(consumerGroupID);
        return this;
    }

    public void setCredentials(SelfManagedKafkaAccessConfigurationCredentials credentials) {
        this.credentials = credentials;
    }

    public SelfManagedKafkaAccessConfigurationCredentials getCredentials() {
        return this.credentials;
    }

    public PipeSourceSelfManagedKafkaParameters withCredentials(SelfManagedKafkaAccessConfigurationCredentials credentials) {
        this.setCredentials(credentials);
        return this;
    }

    public void setServerRootCaCertificate(String serverRootCaCertificate) {
        this.serverRootCaCertificate = serverRootCaCertificate;
    }

    public String getServerRootCaCertificate() {
        return this.serverRootCaCertificate;
    }

    public PipeSourceSelfManagedKafkaParameters withServerRootCaCertificate(String serverRootCaCertificate) {
        this.setServerRootCaCertificate(serverRootCaCertificate);
        return this;
    }

    public void setVpc(SelfManagedKafkaAccessConfigurationVpc vpc) {
        this.vpc = vpc;
    }

    public SelfManagedKafkaAccessConfigurationVpc getVpc() {
        return this.vpc;
    }

    public PipeSourceSelfManagedKafkaParameters withVpc(SelfManagedKafkaAccessConfigurationVpc vpc) {
        this.setVpc(vpc);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTopicName() != null) {
            sb.append("TopicName: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getStartingPosition() != null) {
            sb.append("StartingPosition: ").append(this.getStartingPosition()).append(",");
        }
        if (this.getAdditionalBootstrapServers() != null) {
            sb.append("AdditionalBootstrapServers: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getBatchSize() != null) {
            sb.append("BatchSize: ").append(this.getBatchSize()).append(",");
        }
        if (this.getMaximumBatchingWindowInSeconds() != null) {
            sb.append("MaximumBatchingWindowInSeconds: ").append(this.getMaximumBatchingWindowInSeconds()).append(",");
        }
        if (this.getConsumerGroupID() != null) {
            sb.append("ConsumerGroupID: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getCredentials() != null) {
            sb.append("Credentials: ").append(this.getCredentials()).append(",");
        }
        if (this.getServerRootCaCertificate() != null) {
            sb.append("ServerRootCaCertificate: ").append(this.getServerRootCaCertificate()).append(",");
        }
        if (this.getVpc() != null) {
            sb.append("Vpc: ").append(this.getVpc());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeSourceSelfManagedKafkaParameters)) {
            return false;
        }
        PipeSourceSelfManagedKafkaParameters other = (PipeSourceSelfManagedKafkaParameters)obj;
        if (other.getTopicName() == null ^ this.getTopicName() == null) {
            return false;
        }
        if (other.getTopicName() != null && !other.getTopicName().equals(this.getTopicName())) {
            return false;
        }
        if (other.getStartingPosition() == null ^ this.getStartingPosition() == null) {
            return false;
        }
        if (other.getStartingPosition() != null && !other.getStartingPosition().equals(this.getStartingPosition())) {
            return false;
        }
        if (other.getAdditionalBootstrapServers() == null ^ this.getAdditionalBootstrapServers() == null) {
            return false;
        }
        if (other.getAdditionalBootstrapServers() != null && !other.getAdditionalBootstrapServers().equals(this.getAdditionalBootstrapServers())) {
            return false;
        }
        if (other.getBatchSize() == null ^ this.getBatchSize() == null) {
            return false;
        }
        if (other.getBatchSize() != null && !other.getBatchSize().equals(this.getBatchSize())) {
            return false;
        }
        if (other.getMaximumBatchingWindowInSeconds() == null ^ this.getMaximumBatchingWindowInSeconds() == null) {
            return false;
        }
        if (other.getMaximumBatchingWindowInSeconds() != null && !other.getMaximumBatchingWindowInSeconds().equals(this.getMaximumBatchingWindowInSeconds())) {
            return false;
        }
        if (other.getConsumerGroupID() == null ^ this.getConsumerGroupID() == null) {
            return false;
        }
        if (other.getConsumerGroupID() != null && !other.getConsumerGroupID().equals(this.getConsumerGroupID())) {
            return false;
        }
        if (other.getCredentials() == null ^ this.getCredentials() == null) {
            return false;
        }
        if (other.getCredentials() != null && !other.getCredentials().equals(this.getCredentials())) {
            return false;
        }
        if (other.getServerRootCaCertificate() == null ^ this.getServerRootCaCertificate() == null) {
            return false;
        }
        if (other.getServerRootCaCertificate() != null && !other.getServerRootCaCertificate().equals(this.getServerRootCaCertificate())) {
            return false;
        }
        if (other.getVpc() == null ^ this.getVpc() == null) {
            return false;
        }
        return other.getVpc() == null || other.getVpc().equals(this.getVpc());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTopicName() == null ? 0 : this.getTopicName().hashCode());
        hashCode = 31 * hashCode + (this.getStartingPosition() == null ? 0 : this.getStartingPosition().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalBootstrapServers() == null ? 0 : this.getAdditionalBootstrapServers().hashCode());
        hashCode = 31 * hashCode + (this.getBatchSize() == null ? 0 : this.getBatchSize().hashCode());
        hashCode = 31 * hashCode + (this.getMaximumBatchingWindowInSeconds() == null ? 0 : this.getMaximumBatchingWindowInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getConsumerGroupID() == null ? 0 : this.getConsumerGroupID().hashCode());
        hashCode = 31 * hashCode + (this.getCredentials() == null ? 0 : this.getCredentials().hashCode());
        hashCode = 31 * hashCode + (this.getServerRootCaCertificate() == null ? 0 : this.getServerRootCaCertificate().hashCode());
        hashCode = 31 * hashCode + (this.getVpc() == null ? 0 : this.getVpc().hashCode());
        return hashCode;
    }

    public PipeSourceSelfManagedKafkaParameters clone() {
        try {
            return (PipeSourceSelfManagedKafkaParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipeSourceSelfManagedKafkaParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

