/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacecatalog.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.marketplacecatalog.model.transform.FilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Filter
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<String> valueList;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Filter withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getValueList() {
        return this.valueList;
    }

    public void setValueList(Collection<String> valueList) {
        if (valueList == null) {
            this.valueList = null;
            return;
        }
        this.valueList = new ArrayList<String>(valueList);
    }

    public Filter withValueList(String ... valueList) {
        if (this.valueList == null) {
            this.setValueList(new ArrayList<String>(valueList.length));
        }
        for (String ele : valueList) {
            this.valueList.add(ele);
        }
        return this;
    }

    public Filter withValueList(Collection<String> valueList) {
        this.setValueList(valueList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getValueList() != null) {
            sb.append("ValueList: ").append(this.getValueList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getValueList() == null ^ this.getValueList() == null) {
            return false;
        }
        return other.getValueList() == null || other.getValueList().equals(this.getValueList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getValueList() == null ? 0 : this.getValueList().hashCode());
        return hashCode;
    }

    public Filter clone() {
        try {
            return (Filter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

