/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchainquery.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.managedblockchainquery.model.AssetContract;

@SdkInternalApi
public class AssetContractMarshaller {
    private static final MarshallingInfo<StructuredPojo> CONTRACTIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contractIdentifier").build();
    private static final MarshallingInfo<String> TOKENSTANDARD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tokenStandard").build();
    private static final MarshallingInfo<String> DEPLOYERADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deployerAddress").build();
    private static final AssetContractMarshaller instance = new AssetContractMarshaller();

    public static AssetContractMarshaller getInstance() {
        return instance;
    }

    public void marshall(AssetContract assetContract, ProtocolMarshaller protocolMarshaller) {
        if (assetContract == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)assetContract.getContractIdentifier(), CONTRACTIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)assetContract.getTokenStandard(), TOKENSTANDARD_BINDING);
            protocolMarshaller.marshall((Object)assetContract.getDeployerAddress(), DEPLOYERADDRESS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

