/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mailmanager.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Specifies the email attribute to evaluate in a string expression.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ArchiveStringToEvaluate"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ArchiveStringToEvaluate implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the email attribute to evaluate.
     * </p>
     */
    private String attribute;

    /**
     * <p>
     * The name of the email attribute to evaluate.
     * </p>
     * 
     * @param attribute
     *        The name of the email attribute to evaluate.
     * @see ArchiveStringEmailAttribute
     */

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    /**
     * <p>
     * The name of the email attribute to evaluate.
     * </p>
     * 
     * @return The name of the email attribute to evaluate.
     * @see ArchiveStringEmailAttribute
     */

    public String getAttribute() {
        return this.attribute;
    }

    /**
     * <p>
     * The name of the email attribute to evaluate.
     * </p>
     * 
     * @param attribute
     *        The name of the email attribute to evaluate.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ArchiveStringEmailAttribute
     */

    public ArchiveStringToEvaluate withAttribute(String attribute) {
        setAttribute(attribute);
        return this;
    }

    /**
     * <p>
     * The name of the email attribute to evaluate.
     * </p>
     * 
     * @param attribute
     *        The name of the email attribute to evaluate.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ArchiveStringEmailAttribute
     */

    public ArchiveStringToEvaluate withAttribute(ArchiveStringEmailAttribute attribute) {
        this.attribute = attribute.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAttribute() != null)
            sb.append("Attribute: ").append(getAttribute());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ArchiveStringToEvaluate == false)
            return false;
        ArchiveStringToEvaluate other = (ArchiveStringToEvaluate) obj;
        if (other.getAttribute() == null ^ this.getAttribute() == null)
            return false;
        if (other.getAttribute() != null && other.getAttribute().equals(this.getAttribute()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAttribute() == null) ? 0 : getAttribute().hashCode());
        return hashCode;
    }

    @Override
    public ArchiveStringToEvaluate clone() {
        try {
            return (ArchiveStringToEvaluate) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.mailmanager.model.transform.ArchiveStringToEvaluateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
