/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iot.model.KafkaAction;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class KafkaActionMarshaller {
    private static final MarshallingInfo<String> DESTINATIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationArn").build();
    private static final MarshallingInfo<String> TOPIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("topic").build();
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("key").build();
    private static final MarshallingInfo<String> PARTITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("partition").build();
    private static final MarshallingInfo<Map> CLIENTPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientProperties").build();
    private static final MarshallingInfo<List> HEADERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("headers").build();
    private static final KafkaActionMarshaller instance = new KafkaActionMarshaller();

    public static KafkaActionMarshaller getInstance() {
        return instance;
    }

    public void marshall(KafkaAction kafkaAction, ProtocolMarshaller protocolMarshaller) {
        if (kafkaAction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)kafkaAction.getDestinationArn(), DESTINATIONARN_BINDING);
            protocolMarshaller.marshall((Object)kafkaAction.getTopic(), TOPIC_BINDING);
            protocolMarshaller.marshall((Object)kafkaAction.getKey(), KEY_BINDING);
            protocolMarshaller.marshall((Object)kafkaAction.getPartition(), PARTITION_BINDING);
            protocolMarshaller.marshall(kafkaAction.getClientProperties(), CLIENTPROPERTIES_BINDING);
            protocolMarshaller.marshall(kafkaAction.getHeaders(), HEADERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

