/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.OAuth2PropertiesInput;
import java.util.Map;

@SdkInternalApi
public class OAuth2PropertiesInputMarshaller {
    private static final MarshallingInfo<String> OAUTH2GRANTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OAuth2GrantType").build();
    private static final MarshallingInfo<StructuredPojo> OAUTH2CLIENTAPPLICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OAuth2ClientApplication").build();
    private static final MarshallingInfo<String> TOKENURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TokenUrl").build();
    private static final MarshallingInfo<Map> TOKENURLPARAMETERSMAP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TokenUrlParametersMap").build();
    private static final MarshallingInfo<StructuredPojo> AUTHORIZATIONCODEPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthorizationCodeProperties").build();
    private static final OAuth2PropertiesInputMarshaller instance = new OAuth2PropertiesInputMarshaller();

    public static OAuth2PropertiesInputMarshaller getInstance() {
        return instance;
    }

    public void marshall(OAuth2PropertiesInput oAuth2PropertiesInput, ProtocolMarshaller protocolMarshaller) {
        if (oAuth2PropertiesInput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)oAuth2PropertiesInput.getOAuth2GrantType(), OAUTH2GRANTTYPE_BINDING);
            protocolMarshaller.marshall((Object)oAuth2PropertiesInput.getOAuth2ClientApplication(), OAUTH2CLIENTAPPLICATION_BINDING);
            protocolMarshaller.marshall((Object)oAuth2PropertiesInput.getTokenUrl(), TOKENURL_BINDING);
            protocolMarshaller.marshall(oAuth2PropertiesInput.getTokenUrlParametersMap(), TOKENURLPARAMETERSMAP_BINDING);
            protocolMarshaller.marshall((Object)oAuth2PropertiesInput.getAuthorizationCodeProperties(), AUTHORIZATIONCODEPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

