/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticfilesystem.model.DestinationToCreate;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateReplicationConfigurationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String sourceFileSystemId;
    private SdkInternalList<DestinationToCreate> destinations;

    public void setSourceFileSystemId(String sourceFileSystemId) {
        this.sourceFileSystemId = sourceFileSystemId;
    }

    public String getSourceFileSystemId() {
        return this.sourceFileSystemId;
    }

    public CreateReplicationConfigurationRequest withSourceFileSystemId(String sourceFileSystemId) {
        this.setSourceFileSystemId(sourceFileSystemId);
        return this;
    }

    public List<DestinationToCreate> getDestinations() {
        if (this.destinations == null) {
            this.destinations = new SdkInternalList();
        }
        return this.destinations;
    }

    public void setDestinations(Collection<DestinationToCreate> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new SdkInternalList(destinations);
    }

    public CreateReplicationConfigurationRequest withDestinations(DestinationToCreate ... destinations) {
        if (this.destinations == null) {
            this.setDestinations((Collection<DestinationToCreate>)new SdkInternalList(destinations.length));
        }
        for (DestinationToCreate ele : destinations) {
            this.destinations.add((Object)ele);
        }
        return this;
    }

    public CreateReplicationConfigurationRequest withDestinations(Collection<DestinationToCreate> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceFileSystemId() != null) {
            sb.append("SourceFileSystemId: ").append(this.getSourceFileSystemId()).append(",");
        }
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationConfigurationRequest)) {
            return false;
        }
        CreateReplicationConfigurationRequest other = (CreateReplicationConfigurationRequest)obj;
        if (other.getSourceFileSystemId() == null ^ this.getSourceFileSystemId() == null) {
            return false;
        }
        if (other.getSourceFileSystemId() != null && !other.getSourceFileSystemId().equals(this.getSourceFileSystemId())) {
            return false;
        }
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        return other.getDestinations() == null || other.getDestinations().equals(this.getDestinations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceFileSystemId() == null ? 0 : this.getSourceFileSystemId().hashCode());
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        return hashCode;
    }

    public CreateReplicationConfigurationRequest clone() {
        return (CreateReplicationConfigurationRequest)super.clone();
    }
}

