/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ecr.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribePullThroughCacheRules" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribePullThroughCacheRulesResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * The details of the pull through cache rules.
     * </p>
     */
    private java.util.List<PullThroughCacheRule> pullThroughCacheRules;
    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribePullThroughCacheRulesRequest</code>
     * request. When the results of a <code>DescribePullThroughCacheRulesRequest</code> request exceed
     * <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is null when
     * there are no more results to return.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * The details of the pull through cache rules.
     * </p>
     * 
     * @return The details of the pull through cache rules.
     */

    public java.util.List<PullThroughCacheRule> getPullThroughCacheRules() {
        return pullThroughCacheRules;
    }

    /**
     * <p>
     * The details of the pull through cache rules.
     * </p>
     * 
     * @param pullThroughCacheRules
     *        The details of the pull through cache rules.
     */

    public void setPullThroughCacheRules(java.util.Collection<PullThroughCacheRule> pullThroughCacheRules) {
        if (pullThroughCacheRules == null) {
            this.pullThroughCacheRules = null;
            return;
        }

        this.pullThroughCacheRules = new java.util.ArrayList<PullThroughCacheRule>(pullThroughCacheRules);
    }

    /**
     * <p>
     * The details of the pull through cache rules.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setPullThroughCacheRules(java.util.Collection)} or
     * {@link #withPullThroughCacheRules(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param pullThroughCacheRules
     *        The details of the pull through cache rules.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribePullThroughCacheRulesResult withPullThroughCacheRules(PullThroughCacheRule... pullThroughCacheRules) {
        if (this.pullThroughCacheRules == null) {
            setPullThroughCacheRules(new java.util.ArrayList<PullThroughCacheRule>(pullThroughCacheRules.length));
        }
        for (PullThroughCacheRule ele : pullThroughCacheRules) {
            this.pullThroughCacheRules.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The details of the pull through cache rules.
     * </p>
     * 
     * @param pullThroughCacheRules
     *        The details of the pull through cache rules.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribePullThroughCacheRulesResult withPullThroughCacheRules(java.util.Collection<PullThroughCacheRule> pullThroughCacheRules) {
        setPullThroughCacheRules(pullThroughCacheRules);
        return this;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribePullThroughCacheRulesRequest</code>
     * request. When the results of a <code>DescribePullThroughCacheRulesRequest</code> request exceed
     * <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is null when
     * there are no more results to return.
     * </p>
     * 
     * @param nextToken
     *        The <code>nextToken</code> value to include in a future <code>DescribePullThroughCacheRulesRequest</code>
     *        request. When the results of a <code>DescribePullThroughCacheRulesRequest</code> request exceed
     *        <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is null
     *        when there are no more results to return.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribePullThroughCacheRulesRequest</code>
     * request. When the results of a <code>DescribePullThroughCacheRulesRequest</code> request exceed
     * <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is null when
     * there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>DescribePullThroughCacheRulesRequest</code>
     *         request. When the results of a <code>DescribePullThroughCacheRulesRequest</code> request exceed
     *         <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is null
     *         when there are no more results to return.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribePullThroughCacheRulesRequest</code>
     * request. When the results of a <code>DescribePullThroughCacheRulesRequest</code> request exceed
     * <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is null when
     * there are no more results to return.
     * </p>
     * 
     * @param nextToken
     *        The <code>nextToken</code> value to include in a future <code>DescribePullThroughCacheRulesRequest</code>
     *        request. When the results of a <code>DescribePullThroughCacheRulesRequest</code> request exceed
     *        <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is null
     *        when there are no more results to return.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribePullThroughCacheRulesResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getPullThroughCacheRules() != null)
            sb.append("PullThroughCacheRules: ").append(getPullThroughCacheRules()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribePullThroughCacheRulesResult == false)
            return false;
        DescribePullThroughCacheRulesResult other = (DescribePullThroughCacheRulesResult) obj;
        if (other.getPullThroughCacheRules() == null ^ this.getPullThroughCacheRules() == null)
            return false;
        if (other.getPullThroughCacheRules() != null && other.getPullThroughCacheRules().equals(this.getPullThroughCacheRules()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getPullThroughCacheRules() == null) ? 0 : getPullThroughCacheRules().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public DescribePullThroughCacheRulesResult clone() {
        try {
            return (DescribePullThroughCacheRulesResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
