/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchrum;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cloudwatchrum.AWSCloudWatchRUM;
import com.amazonaws.services.cloudwatchrum.AWSCloudWatchRUMClientBuilder;
import com.amazonaws.services.cloudwatchrum.model.AWSCloudWatchRUMException;
import com.amazonaws.services.cloudwatchrum.model.BatchCreateRumMetricDefinitionsRequest;
import com.amazonaws.services.cloudwatchrum.model.BatchCreateRumMetricDefinitionsResult;
import com.amazonaws.services.cloudwatchrum.model.BatchDeleteRumMetricDefinitionsRequest;
import com.amazonaws.services.cloudwatchrum.model.BatchDeleteRumMetricDefinitionsResult;
import com.amazonaws.services.cloudwatchrum.model.BatchGetRumMetricDefinitionsRequest;
import com.amazonaws.services.cloudwatchrum.model.BatchGetRumMetricDefinitionsResult;
import com.amazonaws.services.cloudwatchrum.model.CreateAppMonitorRequest;
import com.amazonaws.services.cloudwatchrum.model.CreateAppMonitorResult;
import com.amazonaws.services.cloudwatchrum.model.DeleteAppMonitorRequest;
import com.amazonaws.services.cloudwatchrum.model.DeleteAppMonitorResult;
import com.amazonaws.services.cloudwatchrum.model.DeleteRumMetricsDestinationRequest;
import com.amazonaws.services.cloudwatchrum.model.DeleteRumMetricsDestinationResult;
import com.amazonaws.services.cloudwatchrum.model.GetAppMonitorDataRequest;
import com.amazonaws.services.cloudwatchrum.model.GetAppMonitorDataResult;
import com.amazonaws.services.cloudwatchrum.model.GetAppMonitorRequest;
import com.amazonaws.services.cloudwatchrum.model.GetAppMonitorResult;
import com.amazonaws.services.cloudwatchrum.model.ListAppMonitorsRequest;
import com.amazonaws.services.cloudwatchrum.model.ListAppMonitorsResult;
import com.amazonaws.services.cloudwatchrum.model.ListRumMetricsDestinationsRequest;
import com.amazonaws.services.cloudwatchrum.model.ListRumMetricsDestinationsResult;
import com.amazonaws.services.cloudwatchrum.model.ListTagsForResourceRequest;
import com.amazonaws.services.cloudwatchrum.model.ListTagsForResourceResult;
import com.amazonaws.services.cloudwatchrum.model.PutRumEventsRequest;
import com.amazonaws.services.cloudwatchrum.model.PutRumEventsResult;
import com.amazonaws.services.cloudwatchrum.model.PutRumMetricsDestinationRequest;
import com.amazonaws.services.cloudwatchrum.model.PutRumMetricsDestinationResult;
import com.amazonaws.services.cloudwatchrum.model.TagResourceRequest;
import com.amazonaws.services.cloudwatchrum.model.TagResourceResult;
import com.amazonaws.services.cloudwatchrum.model.UntagResourceRequest;
import com.amazonaws.services.cloudwatchrum.model.UntagResourceResult;
import com.amazonaws.services.cloudwatchrum.model.UpdateAppMonitorRequest;
import com.amazonaws.services.cloudwatchrum.model.UpdateAppMonitorResult;
import com.amazonaws.services.cloudwatchrum.model.UpdateRumMetricDefinitionRequest;
import com.amazonaws.services.cloudwatchrum.model.UpdateRumMetricDefinitionResult;
import com.amazonaws.services.cloudwatchrum.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.BatchCreateRumMetricDefinitionsRequestProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.BatchCreateRumMetricDefinitionsResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.BatchDeleteRumMetricDefinitionsRequestProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.BatchDeleteRumMetricDefinitionsResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.BatchGetRumMetricDefinitionsRequestProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.BatchGetRumMetricDefinitionsResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.CreateAppMonitorRequestProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.CreateAppMonitorResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.DeleteAppMonitorRequestProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.DeleteAppMonitorResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.DeleteRumMetricsDestinationRequestProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.DeleteRumMetricsDestinationResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.GetAppMonitorDataRequestProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.GetAppMonitorDataResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.GetAppMonitorRequestProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.GetAppMonitorResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.ListAppMonitorsRequestProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.ListAppMonitorsResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.ListRumMetricsDestinationsRequestProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.ListRumMetricsDestinationsResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.PutRumEventsRequestProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.PutRumEventsResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.PutRumMetricsDestinationRequestProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.PutRumMetricsDestinationResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.UpdateAppMonitorRequestProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.UpdateAppMonitorResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.UpdateRumMetricDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.UpdateRumMetricDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchrum.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import com.amazonaws.util.UriResourcePathUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSCloudWatchRUMClient
extends AmazonWebServiceClient
implements AWSCloudWatchRUM {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCloudWatchRUM.class);
    private static final String DEFAULT_SIGNING_NAME = "rum";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSCloudWatchRUMException.class));

    public static AWSCloudWatchRUMClientBuilder builder() {
        return AWSCloudWatchRUMClientBuilder.standard();
    }

    AWSCloudWatchRUMClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSCloudWatchRUMClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("rum.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudwatchrum/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloudwatchrum/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchCreateRumMetricDefinitionsResult batchCreateRumMetricDefinitions(BatchCreateRumMetricDefinitionsRequest request) {
        request = (BatchCreateRumMetricDefinitionsRequest)this.beforeClientExecution(request);
        return this.executeBatchCreateRumMetricDefinitions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchCreateRumMetricDefinitionsResult executeBatchCreateRumMetricDefinitions(BatchCreateRumMetricDefinitionsRequest batchCreateRumMetricDefinitionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchCreateRumMetricDefinitionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchCreateRumMetricDefinitionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchCreateRumMetricDefinitionsRequestProtocolMarshaller(protocolFactory).marshall((BatchCreateRumMetricDefinitionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchCreateRumMetricDefinitionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RUM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchCreateRumMetricDefinitions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchCreateRumMetricDefinitionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchCreateRumMetricDefinitionsResult batchCreateRumMetricDefinitionsResult = (BatchCreateRumMetricDefinitionsResult)response.getAwsResponse();
            return batchCreateRumMetricDefinitionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchDeleteRumMetricDefinitionsResult batchDeleteRumMetricDefinitions(BatchDeleteRumMetricDefinitionsRequest request) {
        request = (BatchDeleteRumMetricDefinitionsRequest)this.beforeClientExecution(request);
        return this.executeBatchDeleteRumMetricDefinitions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchDeleteRumMetricDefinitionsResult executeBatchDeleteRumMetricDefinitions(BatchDeleteRumMetricDefinitionsRequest batchDeleteRumMetricDefinitionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDeleteRumMetricDefinitionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDeleteRumMetricDefinitionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDeleteRumMetricDefinitionsRequestProtocolMarshaller(protocolFactory).marshall((BatchDeleteRumMetricDefinitionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchDeleteRumMetricDefinitionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RUM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchDeleteRumMetricDefinitions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDeleteRumMetricDefinitionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchDeleteRumMetricDefinitionsResult batchDeleteRumMetricDefinitionsResult = (BatchDeleteRumMetricDefinitionsResult)response.getAwsResponse();
            return batchDeleteRumMetricDefinitionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchGetRumMetricDefinitionsResult batchGetRumMetricDefinitions(BatchGetRumMetricDefinitionsRequest request) {
        request = (BatchGetRumMetricDefinitionsRequest)this.beforeClientExecution(request);
        return this.executeBatchGetRumMetricDefinitions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetRumMetricDefinitionsResult executeBatchGetRumMetricDefinitions(BatchGetRumMetricDefinitionsRequest batchGetRumMetricDefinitionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetRumMetricDefinitionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetRumMetricDefinitionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetRumMetricDefinitionsRequestProtocolMarshaller(protocolFactory).marshall((BatchGetRumMetricDefinitionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetRumMetricDefinitionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RUM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchGetRumMetricDefinitions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetRumMetricDefinitionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetRumMetricDefinitionsResult batchGetRumMetricDefinitionsResult = (BatchGetRumMetricDefinitionsResult)response.getAwsResponse();
            return batchGetRumMetricDefinitionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateAppMonitorResult createAppMonitor(CreateAppMonitorRequest request) {
        request = (CreateAppMonitorRequest)this.beforeClientExecution(request);
        return this.executeCreateAppMonitor(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAppMonitorResult executeCreateAppMonitor(CreateAppMonitorRequest createAppMonitorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAppMonitorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAppMonitorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAppMonitorRequestProtocolMarshaller(protocolFactory).marshall((CreateAppMonitorRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAppMonitorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RUM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAppMonitor");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAppMonitorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAppMonitorResult createAppMonitorResult = (CreateAppMonitorResult)response.getAwsResponse();
            return createAppMonitorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAppMonitorResult deleteAppMonitor(DeleteAppMonitorRequest request) {
        request = (DeleteAppMonitorRequest)this.beforeClientExecution(request);
        return this.executeDeleteAppMonitor(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAppMonitorResult executeDeleteAppMonitor(DeleteAppMonitorRequest deleteAppMonitorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAppMonitorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAppMonitorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAppMonitorRequestProtocolMarshaller(protocolFactory).marshall((DeleteAppMonitorRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAppMonitorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RUM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAppMonitor");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAppMonitorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAppMonitorResult deleteAppMonitorResult = (DeleteAppMonitorResult)response.getAwsResponse();
            return deleteAppMonitorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRumMetricsDestinationResult deleteRumMetricsDestination(DeleteRumMetricsDestinationRequest request) {
        request = (DeleteRumMetricsDestinationRequest)this.beforeClientExecution(request);
        return this.executeDeleteRumMetricsDestination(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRumMetricsDestinationResult executeDeleteRumMetricsDestination(DeleteRumMetricsDestinationRequest deleteRumMetricsDestinationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRumMetricsDestinationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRumMetricsDestinationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRumMetricsDestinationRequestProtocolMarshaller(protocolFactory).marshall((DeleteRumMetricsDestinationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRumMetricsDestinationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RUM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteRumMetricsDestination");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRumMetricsDestinationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRumMetricsDestinationResult deleteRumMetricsDestinationResult = (DeleteRumMetricsDestinationResult)response.getAwsResponse();
            return deleteRumMetricsDestinationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAppMonitorResult getAppMonitor(GetAppMonitorRequest request) {
        request = (GetAppMonitorRequest)this.beforeClientExecution(request);
        return this.executeGetAppMonitor(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAppMonitorResult executeGetAppMonitor(GetAppMonitorRequest getAppMonitorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAppMonitorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAppMonitorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAppMonitorRequestProtocolMarshaller(protocolFactory).marshall((GetAppMonitorRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAppMonitorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RUM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAppMonitor");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAppMonitorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAppMonitorResult getAppMonitorResult = (GetAppMonitorResult)response.getAwsResponse();
            return getAppMonitorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAppMonitorDataResult getAppMonitorData(GetAppMonitorDataRequest request) {
        request = (GetAppMonitorDataRequest)this.beforeClientExecution(request);
        return this.executeGetAppMonitorData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAppMonitorDataResult executeGetAppMonitorData(GetAppMonitorDataRequest getAppMonitorDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAppMonitorDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAppMonitorDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAppMonitorDataRequestProtocolMarshaller(protocolFactory).marshall((GetAppMonitorDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAppMonitorDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RUM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAppMonitorData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAppMonitorDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAppMonitorDataResult getAppMonitorDataResult = (GetAppMonitorDataResult)response.getAwsResponse();
            return getAppMonitorDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAppMonitorsResult listAppMonitors(ListAppMonitorsRequest request) {
        request = (ListAppMonitorsRequest)this.beforeClientExecution(request);
        return this.executeListAppMonitors(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAppMonitorsResult executeListAppMonitors(ListAppMonitorsRequest listAppMonitorsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAppMonitorsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAppMonitorsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAppMonitorsRequestProtocolMarshaller(protocolFactory).marshall((ListAppMonitorsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAppMonitorsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RUM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAppMonitors");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAppMonitorsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAppMonitorsResult listAppMonitorsResult = (ListAppMonitorsResult)response.getAwsResponse();
            return listAppMonitorsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRumMetricsDestinationsResult listRumMetricsDestinations(ListRumMetricsDestinationsRequest request) {
        request = (ListRumMetricsDestinationsRequest)this.beforeClientExecution(request);
        return this.executeListRumMetricsDestinations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRumMetricsDestinationsResult executeListRumMetricsDestinations(ListRumMetricsDestinationsRequest listRumMetricsDestinationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRumMetricsDestinationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRumMetricsDestinationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRumMetricsDestinationsRequestProtocolMarshaller(protocolFactory).marshall((ListRumMetricsDestinationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRumMetricsDestinationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RUM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRumMetricsDestinations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRumMetricsDestinationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRumMetricsDestinationsResult listRumMetricsDestinationsResult = (ListRumMetricsDestinationsResult)response.getAwsResponse();
            return listRumMetricsDestinationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RUM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutRumEventsResult putRumEvents(PutRumEventsRequest request) {
        request = (PutRumEventsRequest)this.beforeClientExecution(request);
        return this.executePutRumEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutRumEventsResult executePutRumEvents(PutRumEventsRequest putRumEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putRumEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutRumEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutRumEventsRequestProtocolMarshaller(protocolFactory).marshall((PutRumEventsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putRumEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RUM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutRumEvents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "dataplane.";
                String resolvedHostPrefix = String.format("dataplane.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutRumEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            PutRumEventsResult putRumEventsResult = (PutRumEventsResult)response.getAwsResponse();
            return putRumEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutRumMetricsDestinationResult putRumMetricsDestination(PutRumMetricsDestinationRequest request) {
        request = (PutRumMetricsDestinationRequest)this.beforeClientExecution(request);
        return this.executePutRumMetricsDestination(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutRumMetricsDestinationResult executePutRumMetricsDestination(PutRumMetricsDestinationRequest putRumMetricsDestinationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putRumMetricsDestinationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutRumMetricsDestinationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutRumMetricsDestinationRequestProtocolMarshaller(protocolFactory).marshall((PutRumMetricsDestinationRequest)super.beforeMarshalling((AmazonWebServiceRequest)putRumMetricsDestinationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RUM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutRumMetricsDestination");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutRumMetricsDestinationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutRumMetricsDestinationResult putRumMetricsDestinationResult = (PutRumMetricsDestinationResult)response.getAwsResponse();
            return putRumMetricsDestinationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RUM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RUM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateAppMonitorResult updateAppMonitor(UpdateAppMonitorRequest request) {
        request = (UpdateAppMonitorRequest)this.beforeClientExecution(request);
        return this.executeUpdateAppMonitor(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateAppMonitorResult executeUpdateAppMonitor(UpdateAppMonitorRequest updateAppMonitorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAppMonitorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAppMonitorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAppMonitorRequestProtocolMarshaller(protocolFactory).marshall((UpdateAppMonitorRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAppMonitorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RUM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateAppMonitor");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAppMonitorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAppMonitorResult updateAppMonitorResult = (UpdateAppMonitorResult)response.getAwsResponse();
            return updateAppMonitorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateRumMetricDefinitionResult updateRumMetricDefinition(UpdateRumMetricDefinitionRequest request) {
        request = (UpdateRumMetricDefinitionRequest)this.beforeClientExecution(request);
        return this.executeUpdateRumMetricDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateRumMetricDefinitionResult executeUpdateRumMetricDefinition(UpdateRumMetricDefinitionRequest updateRumMetricDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRumMetricDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRumMetricDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRumMetricDefinitionRequestProtocolMarshaller(protocolFactory).marshall((UpdateRumMetricDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateRumMetricDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"RUM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateRumMetricDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateRumMetricDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRumMetricDefinitionResult updateRumMetricDefinitionResult = (UpdateRumMetricDefinitionResult)response.getAwsResponse();
            return updateRumMetricDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

