/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.chatbot.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetMicrosoftTeamsChannelConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetMicrosoftTeamsChannelConfigurationResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /** The configuration for a Microsoft Teams channel configured with AWS Chatbot. */
    private TeamsChannelConfiguration channelConfiguration;

    /**
     * The configuration for a Microsoft Teams channel configured with AWS Chatbot.
     * 
     * @param channelConfiguration
     *        The configuration for a Microsoft Teams channel configured with AWS Chatbot.
     */

    public void setChannelConfiguration(TeamsChannelConfiguration channelConfiguration) {
        this.channelConfiguration = channelConfiguration;
    }

    /**
     * The configuration for a Microsoft Teams channel configured with AWS Chatbot.
     * 
     * @return The configuration for a Microsoft Teams channel configured with AWS Chatbot.
     */

    public TeamsChannelConfiguration getChannelConfiguration() {
        return this.channelConfiguration;
    }

    /**
     * The configuration for a Microsoft Teams channel configured with AWS Chatbot.
     * 
     * @param channelConfiguration
     *        The configuration for a Microsoft Teams channel configured with AWS Chatbot.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMicrosoftTeamsChannelConfigurationResult withChannelConfiguration(TeamsChannelConfiguration channelConfiguration) {
        setChannelConfiguration(channelConfiguration);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getChannelConfiguration() != null)
            sb.append("ChannelConfiguration: ").append(getChannelConfiguration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetMicrosoftTeamsChannelConfigurationResult == false)
            return false;
        GetMicrosoftTeamsChannelConfigurationResult other = (GetMicrosoftTeamsChannelConfigurationResult) obj;
        if (other.getChannelConfiguration() == null ^ this.getChannelConfiguration() == null)
            return false;
        if (other.getChannelConfiguration() != null && other.getChannelConfiguration().equals(this.getChannelConfiguration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getChannelConfiguration() == null) ? 0 : getChannelConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public GetMicrosoftTeamsChannelConfigurationResult clone() {
        try {
            return (GetMicrosoftTeamsChannelConfigurationResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
