/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.b2bi.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.b2bi.model.ProfileSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListProfilesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ProfileSummary> profiles;
    private String nextToken;

    public List<ProfileSummary> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(Collection<ProfileSummary> profiles) {
        if (profiles == null) {
            this.profiles = null;
            return;
        }
        this.profiles = new ArrayList<ProfileSummary>(profiles);
    }

    public ListProfilesResult withProfiles(ProfileSummary ... profiles) {
        if (this.profiles == null) {
            this.setProfiles(new ArrayList<ProfileSummary>(profiles.length));
        }
        for (ProfileSummary ele : profiles) {
            this.profiles.add(ele);
        }
        return this;
    }

    public ListProfilesResult withProfiles(Collection<ProfileSummary> profiles) {
        this.setProfiles(profiles);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListProfilesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProfiles() != null) {
            sb.append("Profiles: ").append(this.getProfiles()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfilesResult)) {
            return false;
        }
        ListProfilesResult other = (ListProfilesResult)obj;
        if (other.getProfiles() == null ^ this.getProfiles() == null) {
            return false;
        }
        if (other.getProfiles() != null && !other.getProfiles().equals(this.getProfiles())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProfiles() == null ? 0 : this.getProfiles().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListProfilesResult clone() {
        try {
            return (ListProfilesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

