/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.b2bi.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.b2bi.model.S3Location;
import com.amazonaws.services.b2bi.model.TransformerJobStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetTransformerJobResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String status;
    private List<S3Location> outputFiles;
    private String message;

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public GetTransformerJobResult withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public GetTransformerJobResult withStatus(TransformerJobStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<S3Location> getOutputFiles() {
        return this.outputFiles;
    }

    public void setOutputFiles(Collection<S3Location> outputFiles) {
        if (outputFiles == null) {
            this.outputFiles = null;
            return;
        }
        this.outputFiles = new ArrayList<S3Location>(outputFiles);
    }

    public GetTransformerJobResult withOutputFiles(S3Location ... outputFiles) {
        if (this.outputFiles == null) {
            this.setOutputFiles(new ArrayList<S3Location>(outputFiles.length));
        }
        for (S3Location ele : outputFiles) {
            this.outputFiles.add(ele);
        }
        return this;
    }

    public GetTransformerJobResult withOutputFiles(Collection<S3Location> outputFiles) {
        this.setOutputFiles(outputFiles);
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public GetTransformerJobResult withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getOutputFiles() != null) {
            sb.append("OutputFiles: ").append(this.getOutputFiles()).append(",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: ").append(this.getMessage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransformerJobResult)) {
            return false;
        }
        GetTransformerJobResult other = (GetTransformerJobResult)obj;
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getOutputFiles() == null ^ this.getOutputFiles() == null) {
            return false;
        }
        if (other.getOutputFiles() != null && !other.getOutputFiles().equals(this.getOutputFiles())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        return other.getMessage() == null || other.getMessage().equals(this.getMessage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getOutputFiles() == null ? 0 : this.getOutputFiles().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        return hashCode;
    }

    public GetTransformerJobResult clone() {
        try {
            return (GetTransformerJobResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

