/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apptest.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apptest.model.DataSet;
import com.amazonaws.services.apptest.model.transform.CompareDataSetsStepInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CompareDataSetsStepInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String sourceLocation;
    private String targetLocation;
    private List<DataSet> sourceDataSets;
    private List<DataSet> targetDataSets;

    public void setSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    public CompareDataSetsStepInput withSourceLocation(String sourceLocation) {
        this.setSourceLocation(sourceLocation);
        return this;
    }

    public void setTargetLocation(String targetLocation) {
        this.targetLocation = targetLocation;
    }

    public String getTargetLocation() {
        return this.targetLocation;
    }

    public CompareDataSetsStepInput withTargetLocation(String targetLocation) {
        this.setTargetLocation(targetLocation);
        return this;
    }

    public List<DataSet> getSourceDataSets() {
        return this.sourceDataSets;
    }

    public void setSourceDataSets(Collection<DataSet> sourceDataSets) {
        if (sourceDataSets == null) {
            this.sourceDataSets = null;
            return;
        }
        this.sourceDataSets = new ArrayList<DataSet>(sourceDataSets);
    }

    public CompareDataSetsStepInput withSourceDataSets(DataSet ... sourceDataSets) {
        if (this.sourceDataSets == null) {
            this.setSourceDataSets(new ArrayList<DataSet>(sourceDataSets.length));
        }
        for (DataSet ele : sourceDataSets) {
            this.sourceDataSets.add(ele);
        }
        return this;
    }

    public CompareDataSetsStepInput withSourceDataSets(Collection<DataSet> sourceDataSets) {
        this.setSourceDataSets(sourceDataSets);
        return this;
    }

    public List<DataSet> getTargetDataSets() {
        return this.targetDataSets;
    }

    public void setTargetDataSets(Collection<DataSet> targetDataSets) {
        if (targetDataSets == null) {
            this.targetDataSets = null;
            return;
        }
        this.targetDataSets = new ArrayList<DataSet>(targetDataSets);
    }

    public CompareDataSetsStepInput withTargetDataSets(DataSet ... targetDataSets) {
        if (this.targetDataSets == null) {
            this.setTargetDataSets(new ArrayList<DataSet>(targetDataSets.length));
        }
        for (DataSet ele : targetDataSets) {
            this.targetDataSets.add(ele);
        }
        return this;
    }

    public CompareDataSetsStepInput withTargetDataSets(Collection<DataSet> targetDataSets) {
        this.setTargetDataSets(targetDataSets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceLocation() != null) {
            sb.append("SourceLocation: ").append(this.getSourceLocation()).append(",");
        }
        if (this.getTargetLocation() != null) {
            sb.append("TargetLocation: ").append(this.getTargetLocation()).append(",");
        }
        if (this.getSourceDataSets() != null) {
            sb.append("SourceDataSets: ").append(this.getSourceDataSets()).append(",");
        }
        if (this.getTargetDataSets() != null) {
            sb.append("TargetDataSets: ").append(this.getTargetDataSets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareDataSetsStepInput)) {
            return false;
        }
        CompareDataSetsStepInput other = (CompareDataSetsStepInput)obj;
        if (other.getSourceLocation() == null ^ this.getSourceLocation() == null) {
            return false;
        }
        if (other.getSourceLocation() != null && !other.getSourceLocation().equals(this.getSourceLocation())) {
            return false;
        }
        if (other.getTargetLocation() == null ^ this.getTargetLocation() == null) {
            return false;
        }
        if (other.getTargetLocation() != null && !other.getTargetLocation().equals(this.getTargetLocation())) {
            return false;
        }
        if (other.getSourceDataSets() == null ^ this.getSourceDataSets() == null) {
            return false;
        }
        if (other.getSourceDataSets() != null && !other.getSourceDataSets().equals(this.getSourceDataSets())) {
            return false;
        }
        if (other.getTargetDataSets() == null ^ this.getTargetDataSets() == null) {
            return false;
        }
        return other.getTargetDataSets() == null || other.getTargetDataSets().equals(this.getTargetDataSets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceLocation() == null ? 0 : this.getSourceLocation().hashCode());
        hashCode = 31 * hashCode + (this.getTargetLocation() == null ? 0 : this.getTargetLocation().hashCode());
        hashCode = 31 * hashCode + (this.getSourceDataSets() == null ? 0 : this.getSourceDataSets().hashCode());
        hashCode = 31 * hashCode + (this.getTargetDataSets() == null ? 0 : this.getTargetDataSets().hashCode());
        return hashCode;
    }

    public CompareDataSetsStepInput clone() {
        try {
            return (CompareDataSetsStepInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CompareDataSetsStepInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

