/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.display;

import com.amazon.ask.model.interfaces.display.ImageInstance;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Image {
    @JsonProperty(value="contentDescription")
    private String contentDescription = null;
    @JsonProperty(value="sources")
    private List<ImageInstance> sources = new ArrayList<ImageInstance>();

    private Image() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private Image(Builder builder) {
        if (builder.contentDescription != null) {
            this.contentDescription = builder.contentDescription;
        }
        if (builder.sources != null) {
            this.sources = builder.sources;
        }
    }

    @JsonProperty(value="contentDescription")
    public String getContentDescription() {
        return this.contentDescription;
    }

    @JsonProperty(value="sources")
    public List<ImageInstance> getSources() {
        return this.sources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Image interfacesDisplayImage = (Image)o;
        return Objects.equals(this.contentDescription, interfacesDisplayImage.contentDescription) && Objects.equals(this.sources, interfacesDisplayImage.sources);
    }

    public int hashCode() {
        return Objects.hash(this.contentDescription, this.sources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Image {\n");
        sb.append("    contentDescription: ").append(this.toIndentedString(this.contentDescription)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String contentDescription;
        private List<ImageInstance> sources;

        private Builder() {
        }

        @JsonProperty(value="contentDescription")
        public Builder withContentDescription(String contentDescription) {
            this.contentDescription = contentDescription;
            return this;
        }

        @JsonProperty(value="sources")
        public Builder withSources(List<ImageInstance> sources) {
            this.sources = sources;
            return this;
        }

        public Builder addSourcesItem(ImageInstance sourcesItem) {
            if (this.sources == null) {
                this.sources = new ArrayList<ImageInstance>();
            }
            this.sources.add(sourcesItem);
            return this;
        }

        public Image build() {
            return new Image(this);
        }
    }
}

