/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.dialog;

import com.amazon.ask.model.Request;
import com.amazon.ask.model.dialog.Input;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class InputRequest
extends Request {
    @JsonProperty(value="input")
    private Input input = null;

    private InputRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private InputRequest(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "Dialog.InputRequest";
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.input != null) {
            this.input = builder.input;
        }
    }

    @JsonProperty(value="input")
    public Input getInput() {
        return this.input;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputRequest dialogInputRequest = (InputRequest)o;
        return Objects.equals(this.input, dialogInputRequest.input) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.input, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InputRequest {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private Input input;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="input")
        public Builder withInput(Input input) {
            this.input = input;
            return this;
        }

        public InputRequest build() {
            return new InputRequest(this);
        }
    }
}

