/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.Request;
import com.amazon.ask.model.SessionEndedError;
import com.amazon.ask.model.SessionEndedReason;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class SessionEndedRequest
extends Request {
    @JsonProperty(value="reason")
    private SessionEndedReason reason = null;
    @JsonProperty(value="error")
    private SessionEndedError error = null;

    private SessionEndedRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private SessionEndedRequest(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "SessionEndedRequest";
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.reason != null) {
            this.reason = builder.reason;
        }
        if (builder.error != null) {
            this.error = builder.error;
        }
    }

    @JsonProperty(value="reason")
    public SessionEndedReason getReason() {
        return this.reason;
    }

    @JsonProperty(value="error")
    public SessionEndedError getError() {
        return this.error;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionEndedRequest sessionEndedRequest = (SessionEndedRequest)o;
        return Objects.equals((Object)this.reason, (Object)sessionEndedRequest.reason) && Objects.equals(this.error, sessionEndedRequest.error) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.reason, this.error, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SessionEndedRequest {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private SessionEndedReason reason;
        private SessionEndedError error;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="reason")
        public Builder withReason(SessionEndedReason reason) {
            this.reason = reason;
            return this;
        }

        @JsonProperty(value="error")
        public Builder withError(SessionEndedError error) {
            this.error = error;
            return this;
        }

        public SessionEndedRequest build() {
            return new SessionEndedRequest(this);
        }
    }
}

