/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.interfaces.system;

import com.amazon.speech.speechlet.Application;
import com.amazon.speech.speechlet.Device;
import com.amazon.speech.speechlet.State;
import com.amazon.speech.speechlet.User;
import com.amazon.speech.speechlet.interfaces.system.SystemInterface;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SystemState
extends State<SystemInterface> {
    private final Application application;
    private final User user;
    private final Device device;

    public static Builder builder() {
        return new Builder();
    }

    private SystemState(Builder builder) {
        this.application = builder.application;
        this.user = builder.user;
        this.device = builder.device;
    }

    private SystemState(@JsonProperty(value="application") Application application, @JsonProperty(value="user") User user, @JsonProperty(value="device") Device device) {
        this.application = application;
        this.user = user;
        this.device = device;
    }

    public Application getApplication() {
        return this.application;
    }

    public User getUser() {
        return this.user;
    }

    public Device getDevice() {
        return this.device;
    }

    @Override
    public Class<SystemInterface> getInterfaceClass() {
        return SystemInterface.class;
    }

    public static final class Builder {
        private Application application;
        private User user;
        private Device device;

        private Builder() {
        }

        public Builder withApplication(Application application) {
            this.application = application;
            return this;
        }

        public Builder withUser(User user) {
            this.user = user;
            return this;
        }

        public Builder withDevice(Device device) {
            this.device = device;
            return this;
        }

        public SystemState build() {
            return new SystemState(this);
        }
    }
}

