/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.HttpInputRequestResult;
import co.elastic.clients.elasticsearch.watcher.HttpInputResponseResult;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class WebhookResult
implements JsonpSerializable {
    private final HttpInputRequestResult request;
    @Nullable
    private final HttpInputResponseResult response;
    public static final JsonpDeserializer<WebhookResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WebhookResult::setupWebhookResultDeserializer);

    private WebhookResult(Builder builder) {
        this.request = ApiTypeHelper.requireNonNull(builder.request, this, "request");
        this.response = builder.response;
    }

    public static WebhookResult of(Function<Builder, ObjectBuilder<WebhookResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final HttpInputRequestResult request() {
        return this.request;
    }

    @Nullable
    public final HttpInputResponseResult response() {
        return this.response;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("request");
        this.request.serialize(generator, mapper);
        if (this.response != null) {
            generator.writeKey("response");
            this.response.serialize(generator, mapper);
        }
    }

    protected static void setupWebhookResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::request, HttpInputRequestResult._DESERIALIZER, "request");
        op.add(Builder::response, HttpInputResponseResult._DESERIALIZER, "response");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<WebhookResult> {
        private HttpInputRequestResult request;
        @Nullable
        private HttpInputResponseResult response;

        public final Builder request(HttpInputRequestResult value) {
            this.request = value;
            return this;
        }

        public final Builder request(Function<HttpInputRequestResult.Builder, ObjectBuilder<HttpInputRequestResult>> fn) {
            return this.request(fn.apply(new HttpInputRequestResult.Builder()).build());
        }

        public final Builder response(@Nullable HttpInputResponseResult value) {
            this.response = value;
            return this;
        }

        public final Builder response(Function<HttpInputResponseResult.Builder, ObjectBuilder<HttpInputResponseResult>> fn) {
            return this.response(fn.apply(new HttpInputResponseResult.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WebhookResult build() {
            this._checkSingleUse();
            return new WebhookResult(this);
        }
    }
}

