/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.ActionStatus;
import co.elastic.clients.elasticsearch.watcher.ActivationState;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class ActivationStatus
implements JsonpSerializable {
    private final Map<String, ActionStatus> actions;
    private final ActivationState state;
    private final long version;
    public static final JsonpDeserializer<ActivationStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ActivationStatus::setupActivationStatusDeserializer);

    private ActivationStatus(Builder builder) {
        this.actions = ApiTypeHelper.unmodifiableRequired(builder.actions, (Object)this, "actions");
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
    }

    public static ActivationStatus of(Function<Builder, ObjectBuilder<ActivationStatus>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, ActionStatus> actions() {
        return this.actions;
    }

    public final ActivationState state() {
        return this.state;
    }

    public final long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.actions)) {
            generator.writeKey("actions");
            generator.writeStartObject();
            for (Map.Entry<String, ActionStatus> item0 : this.actions.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        generator.writeKey("version");
        generator.write(this.version);
    }

    protected static void setupActivationStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.stringMapDeserializer(ActionStatus._DESERIALIZER), "actions");
        op.add(Builder::state, ActivationState._DESERIALIZER, "state");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ActivationStatus> {
        private Map<String, ActionStatus> actions;
        private ActivationState state;
        private Long version;

        public final Builder actions(Map<String, ActionStatus> map) {
            this.actions = Builder._mapPutAll(this.actions, map);
            return this;
        }

        public final Builder actions(String key, ActionStatus value) {
            this.actions = Builder._mapPut(this.actions, key, value);
            return this;
        }

        public final Builder actions(String key, Function<ActionStatus.Builder, ObjectBuilder<ActionStatus>> fn) {
            return this.actions(key, fn.apply(new ActionStatus.Builder()).build());
        }

        public final Builder state(ActivationState value) {
            this.state = value;
            return this;
        }

        public final Builder state(Function<ActivationState.Builder, ObjectBuilder<ActivationState>> fn) {
            return this.state(fn.apply(new ActivationState.Builder()).build());
        }

        public final Builder version(long value) {
            this.version = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ActivationStatus build() {
            this._checkSingleUse();
            return new ActivationStatus(this);
        }
    }
}

