/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.rollover;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RolloverConditions
implements JsonpSerializable {
    @Nullable
    private final Time maxAge;
    @Nullable
    private final Long maxDocs;
    @Nullable
    private final String maxSize;
    @Nullable
    private final String maxPrimaryShardSize;
    public static final JsonpDeserializer<RolloverConditions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RolloverConditions::setupRolloverConditionsDeserializer);

    private RolloverConditions(Builder builder) {
        this.maxAge = builder.maxAge;
        this.maxDocs = builder.maxDocs;
        this.maxSize = builder.maxSize;
        this.maxPrimaryShardSize = builder.maxPrimaryShardSize;
    }

    public static RolloverConditions of(Function<Builder, ObjectBuilder<RolloverConditions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time maxAge() {
        return this.maxAge;
    }

    @Nullable
    public final Long maxDocs() {
        return this.maxDocs;
    }

    @Nullable
    public final String maxSize() {
        return this.maxSize;
    }

    @Nullable
    public final String maxPrimaryShardSize() {
        return this.maxPrimaryShardSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxAge != null) {
            generator.writeKey("max_age");
            this.maxAge.serialize(generator, mapper);
        }
        if (this.maxDocs != null) {
            generator.writeKey("max_docs");
            generator.write(this.maxDocs.longValue());
        }
        if (this.maxSize != null) {
            generator.writeKey("max_size");
            generator.write(this.maxSize);
        }
        if (this.maxPrimaryShardSize != null) {
            generator.writeKey("max_primary_shard_size");
            generator.write(this.maxPrimaryShardSize);
        }
    }

    protected static void setupRolloverConditionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxAge, Time._DESERIALIZER, "max_age");
        op.add(Builder::maxDocs, JsonpDeserializer.longDeserializer(), "max_docs");
        op.add(Builder::maxSize, JsonpDeserializer.stringDeserializer(), "max_size");
        op.add(Builder::maxPrimaryShardSize, JsonpDeserializer.stringDeserializer(), "max_primary_shard_size");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RolloverConditions> {
        @Nullable
        private Time maxAge;
        @Nullable
        private Long maxDocs;
        @Nullable
        private String maxSize;
        @Nullable
        private String maxPrimaryShardSize;

        public final Builder maxAge(@Nullable Time value) {
            this.maxAge = value;
            return this;
        }

        public final Builder maxAge(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.maxAge(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxDocs(@Nullable Long value) {
            this.maxDocs = value;
            return this;
        }

        public final Builder maxSize(@Nullable String value) {
            this.maxSize = value;
            return this;
        }

        public final Builder maxPrimaryShardSize(@Nullable String value) {
            this.maxPrimaryShardSize = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RolloverConditions build() {
            this._checkSingleUse();
            return new RolloverConditions(this);
        }
    }
}

