/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.InlineGet;
import co.elastic.clients.elasticsearch.core.explain.ExplanationDetail;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ExplainResponse<TDocument>
implements JsonpSerializable {
    private final String index;
    @Nullable
    private final String type;
    private final String id;
    private final boolean matched;
    @Nullable
    private final ExplanationDetail explanation;
    @Nullable
    private final InlineGet<TDocument> get;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final JsonpDeserializer<ExplainResponse<Object>> _DESERIALIZER = JsonpDeserializer.lazy(() -> ExplainResponse.createExplainResponseDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:_global.explain.TDocument")));

    private ExplainResponse(Builder<TDocument> builder) {
        this.index = ApiTypeHelper.requireNonNull(((Builder)builder).index, this, "index");
        this.type = ((Builder)builder).type;
        this.id = ApiTypeHelper.requireNonNull(((Builder)builder).id, this, "id");
        this.matched = ApiTypeHelper.requireNonNull(((Builder)builder).matched, this, "matched");
        this.explanation = ((Builder)builder).explanation;
        this.get = ((Builder)builder).get;
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public static <TDocument> ExplainResponse<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<ExplainResponse<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    public final String id() {
        return this.id;
    }

    public final boolean matched() {
        return this.matched;
    }

    @Nullable
    public final ExplanationDetail explanation() {
        return this.explanation;
    }

    @Nullable
    public final InlineGet<TDocument> get() {
        return this.get;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_index");
        generator.write(this.index);
        if (this.type != null) {
            generator.writeKey("_type");
            generator.write(this.type);
        }
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("matched");
        generator.write(this.matched);
        if (this.explanation != null) {
            generator.writeKey("explanation");
            this.explanation.serialize(generator, mapper);
        }
        if (this.get != null) {
            generator.writeKey("get");
            this.get.serialize(generator, mapper);
        }
    }

    public static <TDocument> JsonpDeserializer<ExplainResponse<TDocument>> createExplainResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> ExplainResponse.setupExplainResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupExplainResponseDeserializer(ObjectDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "_type");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::matched, JsonpDeserializer.booleanDeserializer(), "matched");
        op.add(Builder::explanation, ExplanationDetail._DESERIALIZER, "explanation");
        op.add(Builder::get, InlineGet.createInlineGetDeserializer(tDocumentDeserializer), "get");
    }

    public static class Builder<TDocument>
    extends WithJsonObjectBuilderBase<Builder<TDocument>>
    implements ObjectBuilder<ExplainResponse<TDocument>> {
        private String index;
        @Nullable
        private String type;
        private String id;
        private Boolean matched;
        @Nullable
        private ExplanationDetail explanation;
        @Nullable
        private InlineGet<TDocument> get;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final Builder<TDocument> index(String value) {
            this.index = value;
            return this;
        }

        public final Builder<TDocument> type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public final Builder<TDocument> id(String value) {
            this.id = value;
            return this;
        }

        public final Builder<TDocument> matched(boolean value) {
            this.matched = value;
            return this;
        }

        public final Builder<TDocument> explanation(@Nullable ExplanationDetail value) {
            this.explanation = value;
            return this;
        }

        public final Builder<TDocument> explanation(Function<ExplanationDetail.Builder, ObjectBuilder<ExplanationDetail>> fn) {
            return this.explanation(fn.apply(new ExplanationDetail.Builder()).build());
        }

        public final Builder<TDocument> get(@Nullable InlineGet<TDocument> value) {
            this.get = value;
            return this;
        }

        public final Builder<TDocument> get(Function<InlineGet.Builder<TDocument>, ObjectBuilder<InlineGet<TDocument>>> fn) {
            return this.get(fn.apply(new InlineGet.Builder()).build());
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public ExplainResponse<TDocument> build() {
            this._checkSingleUse();
            return new ExplainResponse(this);
        }
    }
}

