/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr.stats;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch.ccr.stats.AutoFollowedCluster;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class AutoFollowStats
implements JsonpSerializable {
    private final List<AutoFollowedCluster> autoFollowedClusters;
    private final long numberOfFailedFollowIndices;
    private final long numberOfFailedRemoteClusterStateRequests;
    private final long numberOfSuccessfulFollowIndices;
    private final List<ErrorCause> recentAutoFollowErrors;
    public static final JsonpDeserializer<AutoFollowStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoFollowStats::setupAutoFollowStatsDeserializer);

    private AutoFollowStats(Builder builder) {
        this.autoFollowedClusters = ApiTypeHelper.unmodifiableRequired(builder.autoFollowedClusters, (Object)this, "autoFollowedClusters");
        this.numberOfFailedFollowIndices = ApiTypeHelper.requireNonNull(builder.numberOfFailedFollowIndices, this, "numberOfFailedFollowIndices");
        this.numberOfFailedRemoteClusterStateRequests = ApiTypeHelper.requireNonNull(builder.numberOfFailedRemoteClusterStateRequests, this, "numberOfFailedRemoteClusterStateRequests");
        this.numberOfSuccessfulFollowIndices = ApiTypeHelper.requireNonNull(builder.numberOfSuccessfulFollowIndices, this, "numberOfSuccessfulFollowIndices");
        this.recentAutoFollowErrors = ApiTypeHelper.unmodifiableRequired(builder.recentAutoFollowErrors, (Object)this, "recentAutoFollowErrors");
    }

    public static AutoFollowStats of(Function<Builder, ObjectBuilder<AutoFollowStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<AutoFollowedCluster> autoFollowedClusters() {
        return this.autoFollowedClusters;
    }

    public final long numberOfFailedFollowIndices() {
        return this.numberOfFailedFollowIndices;
    }

    public final long numberOfFailedRemoteClusterStateRequests() {
        return this.numberOfFailedRemoteClusterStateRequests;
    }

    public final long numberOfSuccessfulFollowIndices() {
        return this.numberOfSuccessfulFollowIndices;
    }

    public final List<ErrorCause> recentAutoFollowErrors() {
        return this.recentAutoFollowErrors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.autoFollowedClusters)) {
            generator.writeKey("auto_followed_clusters");
            generator.writeStartArray();
            for (AutoFollowedCluster autoFollowedCluster : this.autoFollowedClusters) {
                autoFollowedCluster.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("number_of_failed_follow_indices");
        generator.write(this.numberOfFailedFollowIndices);
        generator.writeKey("number_of_failed_remote_cluster_state_requests");
        generator.write(this.numberOfFailedRemoteClusterStateRequests);
        generator.writeKey("number_of_successful_follow_indices");
        generator.write(this.numberOfSuccessfulFollowIndices);
        if (ApiTypeHelper.isDefined(this.recentAutoFollowErrors)) {
            generator.writeKey("recent_auto_follow_errors");
            generator.writeStartArray();
            for (ErrorCause errorCause : this.recentAutoFollowErrors) {
                errorCause.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupAutoFollowStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::autoFollowedClusters, JsonpDeserializer.arrayDeserializer(AutoFollowedCluster._DESERIALIZER), "auto_followed_clusters");
        op.add(Builder::numberOfFailedFollowIndices, JsonpDeserializer.longDeserializer(), "number_of_failed_follow_indices");
        op.add(Builder::numberOfFailedRemoteClusterStateRequests, JsonpDeserializer.longDeserializer(), "number_of_failed_remote_cluster_state_requests");
        op.add(Builder::numberOfSuccessfulFollowIndices, JsonpDeserializer.longDeserializer(), "number_of_successful_follow_indices");
        op.add(Builder::recentAutoFollowErrors, JsonpDeserializer.arrayDeserializer(ErrorCause._DESERIALIZER), "recent_auto_follow_errors");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AutoFollowStats> {
        private List<AutoFollowedCluster> autoFollowedClusters;
        private Long numberOfFailedFollowIndices;
        private Long numberOfFailedRemoteClusterStateRequests;
        private Long numberOfSuccessfulFollowIndices;
        private List<ErrorCause> recentAutoFollowErrors;

        public final Builder autoFollowedClusters(List<AutoFollowedCluster> list) {
            this.autoFollowedClusters = Builder._listAddAll(this.autoFollowedClusters, list);
            return this;
        }

        public final Builder autoFollowedClusters(AutoFollowedCluster value, AutoFollowedCluster ... values) {
            this.autoFollowedClusters = Builder._listAdd(this.autoFollowedClusters, value, values);
            return this;
        }

        public final Builder autoFollowedClusters(Function<AutoFollowedCluster.Builder, ObjectBuilder<AutoFollowedCluster>> fn) {
            return this.autoFollowedClusters(fn.apply(new AutoFollowedCluster.Builder()).build(), new AutoFollowedCluster[0]);
        }

        public final Builder numberOfFailedFollowIndices(long value) {
            this.numberOfFailedFollowIndices = value;
            return this;
        }

        public final Builder numberOfFailedRemoteClusterStateRequests(long value) {
            this.numberOfFailedRemoteClusterStateRequests = value;
            return this;
        }

        public final Builder numberOfSuccessfulFollowIndices(long value) {
            this.numberOfSuccessfulFollowIndices = value;
            return this;
        }

        public final Builder recentAutoFollowErrors(List<ErrorCause> list) {
            this.recentAutoFollowErrors = Builder._listAddAll(this.recentAutoFollowErrors, list);
            return this;
        }

        public final Builder recentAutoFollowErrors(ErrorCause value, ErrorCause ... values) {
            this.recentAutoFollowErrors = Builder._listAdd(this.recentAutoFollowErrors, value, values);
            return this;
        }

        public final Builder recentAutoFollowErrors(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.recentAutoFollowErrors(fn.apply(new ErrorCause.Builder()).build(), new ErrorCause[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AutoFollowStats build() {
            this._checkSingleUse();
            return new AutoFollowStats(this);
        }
    }
}

