/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat.ml_datafeeds;

import co.elastic.clients.elasticsearch.ml.DatafeedState;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DatafeedsRecord
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final DatafeedState state;
    @Nullable
    private final String assignmentExplanation;
    @Nullable
    private final String bucketsCount;
    @Nullable
    private final String searchCount;
    @Nullable
    private final String searchTime;
    @Nullable
    private final String searchBucketAvg;
    @Nullable
    private final String searchExpAvgHour;
    @Nullable
    private final String nodeId;
    @Nullable
    private final String nodeName;
    @Nullable
    private final String nodeEphemeralId;
    @Nullable
    private final String nodeAddress;
    public static final JsonpDeserializer<DatafeedsRecord> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DatafeedsRecord::setupDatafeedsRecordDeserializer);

    private DatafeedsRecord(Builder builder) {
        this.id = builder.id;
        this.state = builder.state;
        this.assignmentExplanation = builder.assignmentExplanation;
        this.bucketsCount = builder.bucketsCount;
        this.searchCount = builder.searchCount;
        this.searchTime = builder.searchTime;
        this.searchBucketAvg = builder.searchBucketAvg;
        this.searchExpAvgHour = builder.searchExpAvgHour;
        this.nodeId = builder.nodeId;
        this.nodeName = builder.nodeName;
        this.nodeEphemeralId = builder.nodeEphemeralId;
        this.nodeAddress = builder.nodeAddress;
    }

    public static DatafeedsRecord of(Function<Builder, ObjectBuilder<DatafeedsRecord>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final DatafeedState state() {
        return this.state;
    }

    @Nullable
    public final String assignmentExplanation() {
        return this.assignmentExplanation;
    }

    @Nullable
    public final String bucketsCount() {
        return this.bucketsCount;
    }

    @Nullable
    public final String searchCount() {
        return this.searchCount;
    }

    @Nullable
    public final String searchTime() {
        return this.searchTime;
    }

    @Nullable
    public final String searchBucketAvg() {
        return this.searchBucketAvg;
    }

    @Nullable
    public final String searchExpAvgHour() {
        return this.searchExpAvgHour;
    }

    @Nullable
    public final String nodeId() {
        return this.nodeId;
    }

    @Nullable
    public final String nodeName() {
        return this.nodeName;
    }

    @Nullable
    public final String nodeEphemeralId() {
        return this.nodeEphemeralId;
    }

    @Nullable
    public final String nodeAddress() {
        return this.nodeAddress;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (this.state != null) {
            generator.writeKey("state");
            this.state.serialize(generator, mapper);
        }
        if (this.assignmentExplanation != null) {
            generator.writeKey("assignment_explanation");
            generator.write(this.assignmentExplanation);
        }
        if (this.bucketsCount != null) {
            generator.writeKey("buckets.count");
            generator.write(this.bucketsCount);
        }
        if (this.searchCount != null) {
            generator.writeKey("search.count");
            generator.write(this.searchCount);
        }
        if (this.searchTime != null) {
            generator.writeKey("search.time");
            generator.write(this.searchTime);
        }
        if (this.searchBucketAvg != null) {
            generator.writeKey("search.bucket_avg");
            generator.write(this.searchBucketAvg);
        }
        if (this.searchExpAvgHour != null) {
            generator.writeKey("search.exp_avg_hour");
            generator.write(this.searchExpAvgHour);
        }
        if (this.nodeId != null) {
            generator.writeKey("node.id");
            generator.write(this.nodeId);
        }
        if (this.nodeName != null) {
            generator.writeKey("node.name");
            generator.write(this.nodeName);
        }
        if (this.nodeEphemeralId != null) {
            generator.writeKey("node.ephemeral_id");
            generator.write(this.nodeEphemeralId);
        }
        if (this.nodeAddress != null) {
            generator.writeKey("node.address");
            generator.write(this.nodeAddress);
        }
    }

    protected static void setupDatafeedsRecordDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::state, DatafeedState._DESERIALIZER, "state", "s");
        op.add(Builder::assignmentExplanation, JsonpDeserializer.stringDeserializer(), "assignment_explanation", "ae");
        op.add(Builder::bucketsCount, JsonpDeserializer.stringDeserializer(), "buckets.count", "bc", "bucketsCount");
        op.add(Builder::searchCount, JsonpDeserializer.stringDeserializer(), "search.count", "sc", "searchCount");
        op.add(Builder::searchTime, JsonpDeserializer.stringDeserializer(), "search.time", "st", "searchTime");
        op.add(Builder::searchBucketAvg, JsonpDeserializer.stringDeserializer(), "search.bucket_avg", "sba", "searchBucketAvg");
        op.add(Builder::searchExpAvgHour, JsonpDeserializer.stringDeserializer(), "search.exp_avg_hour", "seah", "searchExpAvgHour");
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node.id", "ni", "nodeId");
        op.add(Builder::nodeName, JsonpDeserializer.stringDeserializer(), "node.name", "nn", "nodeName");
        op.add(Builder::nodeEphemeralId, JsonpDeserializer.stringDeserializer(), "node.ephemeral_id", "ne", "nodeEphemeralId");
        op.add(Builder::nodeAddress, JsonpDeserializer.stringDeserializer(), "node.address", "na", "nodeAddress");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DatafeedsRecord> {
        @Nullable
        private String id;
        @Nullable
        private DatafeedState state;
        @Nullable
        private String assignmentExplanation;
        @Nullable
        private String bucketsCount;
        @Nullable
        private String searchCount;
        @Nullable
        private String searchTime;
        @Nullable
        private String searchBucketAvg;
        @Nullable
        private String searchExpAvgHour;
        @Nullable
        private String nodeId;
        @Nullable
        private String nodeName;
        @Nullable
        private String nodeEphemeralId;
        @Nullable
        private String nodeAddress;

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder state(@Nullable DatafeedState value) {
            this.state = value;
            return this;
        }

        public final Builder assignmentExplanation(@Nullable String value) {
            this.assignmentExplanation = value;
            return this;
        }

        public final Builder bucketsCount(@Nullable String value) {
            this.bucketsCount = value;
            return this;
        }

        public final Builder searchCount(@Nullable String value) {
            this.searchCount = value;
            return this;
        }

        public final Builder searchTime(@Nullable String value) {
            this.searchTime = value;
            return this;
        }

        public final Builder searchBucketAvg(@Nullable String value) {
            this.searchBucketAvg = value;
            return this;
        }

        public final Builder searchExpAvgHour(@Nullable String value) {
            this.searchExpAvgHour = value;
            return this;
        }

        public final Builder nodeId(@Nullable String value) {
            this.nodeId = value;
            return this;
        }

        public final Builder nodeName(@Nullable String value) {
            this.nodeName = value;
            return this;
        }

        public final Builder nodeEphemeralId(@Nullable String value) {
            this.nodeEphemeralId = value;
            return this;
        }

        public final Builder nodeAddress(@Nullable String value) {
            this.nodeAddress = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DatafeedsRecord build() {
            this._checkSingleUse();
            return new DatafeedsRecord(this);
        }
    }
}

