/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.dispatch.redis;

import cn.ponfee.scheduler.common.base.TimingWheel;
import cn.ponfee.scheduler.common.concurrent.NamedThreadFactory;
import cn.ponfee.scheduler.common.concurrent.ThreadPoolExecutors;
import cn.ponfee.scheduler.common.lock.RedisLock;
import cn.ponfee.scheduler.common.spring.RedisKeyRenewal;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.core.param.ExecuteParam;
import cn.ponfee.scheduler.dispatch.TaskReceiver;
import cn.ponfee.scheduler.dispatch.redis.RedisTaskDispatchingUtils;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class RedisTaskReceiver
extends TaskReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(RedisTaskReceiver.class);
    private static final RedisScript<List> BATCH_POP_SCRIPT_OBJECT = new DefaultRedisScript("local ret=redis.call('lrange',KEYS[1],0,ARGV[1]-1);redis.call('ltrim',KEYS[1],ARGV[1],-1);return ret;", List.class);
    private static final String BATCH_POP_SCRIPT_SHA1 = BATCH_POP_SCRIPT_OBJECT.getSha1();
    private static final byte[] BATCH_POP_SCRIPT_BYTES = BATCH_POP_SCRIPT_OBJECT.getScriptAsString().getBytes(StandardCharsets.UTF_8);
    private static final byte[] LIST_POP_BATCH_SIZE_BYTES = "200".getBytes(StandardCharsets.UTF_8);
    private final Worker currentWorker;
    private final RedisTemplate<String, String> redisTemplate;
    private final byte[] currentWorkerRedisKey;
    private final RedisKeyRenewal redisKeyRenewal;
    private final byte[][] keysAndArgs;
    private final ScheduledThreadPoolExecutor receiveTaskScheduledExecutor;
    private final AtomicBoolean start = new AtomicBoolean(false);

    public RedisTaskReceiver(Worker currentWorker, TimingWheel<ExecuteParam> timingWheel, RedisTemplate<String, String> redisTemplate) {
        super(timingWheel);
        this.currentWorker = currentWorker;
        this.redisTemplate = redisTemplate;
        this.currentWorkerRedisKey = RedisTaskDispatchingUtils.buildDispatchTasksKey(currentWorker).getBytes();
        this.keysAndArgs = new byte[][]{this.currentWorkerRedisKey, LIST_POP_BATCH_SIZE_BYTES};
        this.redisKeyRenewal = new RedisKeyRenewal(redisTemplate, this.currentWorkerRedisKey);
        this.receiveTaskScheduledExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("redis_task_receiver", true), ThreadPoolExecutors.DISCARD);
    }

    public void start() {
        if (!this.start.compareAndSet(false, true)) {
            return;
        }
        this.receiveTaskScheduledExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.doReceive();
            }
            catch (Exception e) {
                LOG.error("Redis task receive scheduled error.", (Throwable)e);
            }
        }, 3L, 1L, TimeUnit.SECONDS);
    }

    public void close() {
        this.receiveTaskScheduledExecutor.shutdownNow();
    }

    private void doReceive() {
        List result = (List)this.redisTemplate.execute(conn -> {
            if (conn.isPipelined() || conn.isQueueing()) {
                throw new UnsupportedOperationException("Unsupported pipelined or queueing redis operations.");
            }
            try {
                return (List)conn.evalSha(BATCH_POP_SCRIPT_SHA1, ReturnType.MULTI, 1, this.keysAndArgs);
            }
            catch (Exception e) {
                LOG.warn("Call redis eval sha occur error.", (Throwable)e);
                if (!RedisLock.exceptionContainsNoScriptError((Throwable)e)) {
                    throw e instanceof RuntimeException ? (RuntimeException)e : new RedisSystemException(e.getMessage(), (Throwable)e);
                }
                return (List)conn.eval(BATCH_POP_SCRIPT_BYTES, ReturnType.MULTI, 1, this.keysAndArgs);
            }
        });
        this.redisKeyRenewal.renewIfNecessary();
        if (result == null || result.isEmpty()) {
            return;
        }
        for (byte[] bytes : result) {
            ExecuteParam executeParam = ExecuteParam.deserialize((byte[])bytes);
            executeParam.setWorker(this.currentWorker);
            super.receive(executeParam);
        }
    }
}

