/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.CachedPointSet;
import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.hups.PointSetRandomization;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.util.PrintfFormat;
import umontreal.ssj.util.sort.MultiDimSort;

public class SortedAndCutPointSet
extends CachedPointSet {
    protected int[] index;
    protected MultiDimSort sort;
    protected int numSortCoord;

    public SortedAndCutPointSet(PointSet P, MultiDimSort sort) {
        super(P, 0, P.getNumPoints(), 0, sort.dimension() + 1);
        this.numPoints = P.getNumPoints();
        this.numSortCoord = sort.dimension();
        this.sort = sort;
        this.P = P;
        this.makeIndex();
        this.dim = P.getDimension() - this.numSortCoord;
        this.x = new double[this.numPoints][this.dim];
        this.fillCacheByIndex(this.numSortCoord, this.dim);
    }

    protected int[] makeIndex() {
        int i;
        for (i = 0; i < this.numPoints; ++i) {
            this.x[i][this.numSortCoord] = i;
        }
        this.sort.sort(this.x, 0, this.numPoints);
        this.index = new int[this.numPoints];
        for (i = 0; i < this.numPoints; ++i) {
            this.index[(int)this.x[i][this.numSortCoord]] = i;
        }
        return this.index;
    }

    protected void fillCacheByIndex(int fromDim, int dim) {
        PointSetIterator itr = this.P.iterator();
        for (int i = 0; i < this.numPoints; ++i) {
            itr.nextPoint(this.x[this.index[i]], fromDim, dim);
        }
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    public MultiDimSort getSort() {
        return this.sort;
    }

    @Override
    public PointSetIterator iterator() {
        return new SortedAndCutPointSetIterator();
    }

    @Override
    public void addRandomShift(int d1, int d2, RandomStream stream) {
        this.P.addRandomShift(d1 + this.numSortCoord, d2 + this.numSortCoord, stream);
        this.fillCacheByIndex(d1 + this.numSortCoord, d2 + this.numSortCoord);
    }

    @Override
    public void randomize(PointSetRandomization rand) {
        this.P.randomize(rand);
        this.fillCacheByIndex(this.numSortCoord, this.dim);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("SortAndCutPointSet " + PrintfFormat.NEWLINE);
        sb.append(PrintfFormat.NEWLINE + "Cached point set information {" + PrintfFormat.NEWLINE);
        sb.append(this.P.toString());
        sb.append(PrintfFormat.NEWLINE + "}");
        return sb.toString();
    }

    protected class SortedAndCutPointSetIterator
    extends PointSet.DefaultPointSetIterator {
        protected SortedAndCutPointSetIterator() {
            super(SortedAndCutPointSet.this);
        }

        @Override
        public double nextCoordinate() {
            if (this.getCurPointIndex() >= SortedAndCutPointSet.this.numPoints || this.getCurCoordIndex() >= SortedAndCutPointSet.this.dim) {
                this.outOfBounds();
            }
            return SortedAndCutPointSet.this.x[this.curPointIndex][this.curCoordIndex++];
        }
    }
}

