/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.ContainerPointSet;
import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.util.PrintfFormat;

public class RandShiftedPointSet
extends ContainerPointSet {
    protected double[] shift;
    protected int dimShift = 0;
    protected int capacityShift = 0;
    protected RandomStream shiftStream;

    public RandShiftedPointSet(PointSet P, int dimShift, RandomStream stream) {
        this.init(P);
        if (dimShift <= 0) {
            throw new IllegalArgumentException("Cannot construct RandShiftedPointSet with dimShift <= 0");
        }
        this.shiftStream = stream;
        this.shift = new double[dimShift];
        this.capacityShift = this.dimShift = dimShift;
    }

    public int getShiftDimension() {
        return this.dimShift;
    }

    @Override
    public void addRandomShift(int d1, int d2, RandomStream stream) {
        if (null == stream) {
            throw new IllegalArgumentException(PrintfFormat.NEWLINE + "   Calling addRandomShift with null stream");
        }
        if (stream != this.shiftStream) {
            this.shiftStream = stream;
        }
        this.addRandomShift(d1, d2);
    }

    @Override
    public void addRandomShift(RandomStream stream) {
        if (stream != this.shiftStream) {
            this.shiftStream = stream;
        }
        this.addRandomShift(0, this.dimShift);
    }

    @Override
    @Deprecated
    public void addRandomShift(int d1, int d2) {
        if (d1 < 0 || d1 > d2) {
            throw new IllegalArgumentException("illegal parameter d1 or d2");
        }
        if (d2 > this.capacityShift) {
            int d3;
            for (d3 = Math.max(4, this.capacityShift); d2 > d3; d3 *= 2) {
            }
            double[] temp = new double[d3];
            this.capacityShift = d3;
            for (int i = 0; i < d1; ++i) {
                temp[i] = this.shift[i];
            }
            this.shift = temp;
        }
        this.dimShift = d2;
        for (int i = d1; i < d2; ++i) {
            this.shift[i] = this.shiftStream.nextDouble();
        }
    }

    @Override
    @Deprecated
    public void addRandomShift() {
        this.addRandomShift(0, this.dimShift);
    }

    @Override
    public String toString() {
        return "RandShiftedPointSet of: {" + PrintfFormat.NEWLINE + this.P.toString() + PrintfFormat.NEWLINE + "}";
    }

    @Override
    public PointSetIterator iterator() {
        return new RandShiftedPointSetIterator();
    }

    private class RandShiftedPointSetIterator
    extends ContainerPointSet.ContainerPointSetIterator {
        private RandShiftedPointSetIterator() {
        }

        public double getCoordinate(int i, int j) {
            double u;
            int d1 = this.innerIterator.getCurCoordIndex();
            if (RandShiftedPointSet.this.dimShift <= d1) {
                RandShiftedPointSet.this.addRandomShift(RandShiftedPointSet.this.dimShift, 1 + d1);
            }
            if ((u = RandShiftedPointSet.this.P.getCoordinate(i, j) + RandShiftedPointSet.this.shift[j]) >= 1.0) {
                u -= 1.0;
            }
            if (u > 0.0) {
                return u;
            }
            return this.EpsilonHalf;
        }

        @Override
        public double nextCoordinate() {
            int d1 = this.innerIterator.getCurCoordIndex();
            if (RandShiftedPointSet.this.dimShift <= d1) {
                RandShiftedPointSet.this.addRandomShift(RandShiftedPointSet.this.dimShift, 1 + d1);
            }
            double u = RandShiftedPointSet.this.shift[d1];
            if ((u += this.innerIterator.nextCoordinate()) >= 1.0) {
                u -= 1.0;
            }
            if (u > 0.0) {
                return u;
            }
            return this.EpsilonHalf;
        }
    }
}

