/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.CachedPointSet;
import umontreal.ssj.hups.DigitalNetBase2;
import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.PointSetRandomization;
import umontreal.ssj.rng.RandomStream;

public class NestedUniformScrambling
implements PointSetRandomization {
    private RandomStream stream;
    private int numBits;

    public NestedUniformScrambling() {
        this(null);
    }

    public NestedUniformScrambling(RandomStream stream) {
        this(stream, 0);
    }

    public NestedUniformScrambling(RandomStream stream, int numBits) {
        this.stream = stream;
        this.numBits = numBits;
    }

    @Override
    public RandomStream getStream() {
        return this.stream;
    }

    @Override
    public void setStream(RandomStream stream) {
        this.stream = stream;
    }

    public void setNumBits(int numBits) {
        this.numBits = numBits;
    }

    @Override
    public void randomize(PointSet p) {
        CachedPointSet cp;
        if (p instanceof CachedPointSet && (cp = (CachedPointSet)p).getParentPointSet() instanceof DigitalNetBase2) {
            ((DigitalNetBase2)cp.getParentPointSet()).nestedUniformScramble(this.stream, cp.getArray(), this.numBits);
            return;
        }
        throw new IllegalArgumentException("NestedUniformScrambling can only randomize a CachedPointSet of a DigitalNetBase2");
    }
}

