/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle.csv;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.i18n.plugin.I18nUtil;
import org.nuiton.i18n.plugin.bundle.csv.AbstractCsvBundleMojo;
import org.nuiton.i18n.plugin.bundle.csv.I18nBundleModel;
import org.nuiton.i18n.plugin.bundle.csv.I18nBundleModelRow;
import org.nuiton.io.SortedProperties;

@Mojo(name="split-csv-bundle", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresProject=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class SplitCsvBundleMojo
extends AbstractCsvBundleMojo {
    @Parameter(property="i18n.bundleOutputName", defaultValue="${project.artifactId}-i18n", required=true)
    protected String bundleOutputName;
    @Parameter(property="i18n.bundleOutputDir", defaultValue="${project.build.directory}", required=true)
    protected File bundleOutputDir;
    @Parameter(property="i18n.artifactId", defaultValue="${project.artifactId}", readonly=true)
    protected String artifactId;
    @Parameter(property="i18n.bundleCsvFile", required=true)
    protected File bundleCsvFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAction() throws Exception {
        LinkedList rows;
        if (!this.silent) {
            this.getLog().info((CharSequence)("config - locales          : " + Arrays.toString(this.locales)));
            this.getLog().info((CharSequence)("config - bundle directory : " + this.bundleOutputDir));
            this.getLog().info((CharSequence)("config - bundle name      : " + this.bundleOutputName));
            this.getLog().info((CharSequence)("config - csv separator    : " + this.bundleCsvSeparator));
            this.getLog().info((CharSequence)("config - csv file         : " + this.bundleCsvFile));
        }
        I18nBundleModel importModel = new I18nBundleModel(this.bundleCsvSeparator, this.locales);
        FileInputStream inputStream = FileUtils.openInputStream((File)this.bundleCsvFile);
        try {
            Import newImport = Import.newImport((ImportModel)importModel, (InputStream)inputStream);
            rows = Lists.newLinkedList((Iterable)newImport);
            inputStream.close();
            newImport.close();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        for (Locale locale : this.locales) {
            File bundleFile = I18nUtil.getI18nFile(this.bundleOutputDir, this.artifactId, locale, false);
            SortedProperties properties = new SortedProperties(this.encoding);
            for (I18nBundleModelRow row : rows) {
                properties.put((Object)row.getKey(), (Object)row.getLocaleValue(locale));
            }
            if (!this.isSilent()) {
                this.getLog().info((CharSequence)String.format("Extract locale bundle %s to %s", locale, bundleFile));
            }
            properties.store(bundleFile);
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Will split bundles in " + this.bundleOutputDir));
        }
        this.createDirectoryIfNecessary(this.bundleOutputDir);
    }
}

