/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.SortedSetMultimap;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.AbstractI18nGenerateMojo;
import org.nuiton.i18n.plugin.I18nUtil;
import org.nuiton.i18n.plugin.bundle.BundleValidation;
import org.nuiton.io.SortedProperties;

@Mojo(name="check-bundles-integrity", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class CheckBundlesIntegrityMojo
extends AbstractI18nGenerateMojo {
    @Parameter(property="i18n.src", defaultValue="${basedir}/src/main/resources/i18n", required=true)
    protected File src;
    @Parameter(property="i18n.showEmpty", defaultValue="false", required=true)
    protected boolean showEmpty;
    @Parameter(property="i18n.showMissing", defaultValue="false", required=true)
    protected boolean showMissing;
    @Parameter(property="i18n.failsIfWarning", defaultValue="false")
    protected boolean failsIfWarning;

    protected void doAction() throws Exception {
        Locale locale2;
        if (!this.silent) {
            this.getLog().info((CharSequence)("config - src basedir : " + this.src.getAbsolutePath()));
            this.getLog().info((CharSequence)("config - locales     : " + Arrays.toString(this.locales)));
        }
        BundleValidation bundleValidation = new BundleValidation(this.locales);
        for (Locale locale2 : this.locales) {
            File bundleSrc = I18nUtil.getI18nFile(this.src, this.artifactId, locale2, false);
            SortedProperties propertiesSrc = new SortedProperties(this.encoding);
            if (bundleSrc.exists()) {
                propertiesSrc.load(bundleSrc);
            }
            this.checkBundle(locale2, (Properties)propertiesSrc, this.showEmpty, bundleValidation);
            ImmutableSet keys = Maps.fromProperties((Properties)propertiesSrc).keySet();
            bundleValidation.getKeysPerLocale().putAll((Object)locale2, (Iterable)keys);
        }
        SortedSetMultimap<Locale, String> missingKeysPerLocale = bundleValidation.getMissingKeysPerLocale();
        if (missingKeysPerLocale.isEmpty()) {
            if (!this.silent) {
                this.getLog().info((CharSequence)("all locales for bundle " + this.artifactId + " are consistent"));
            }
        } else if (this.showMissing) {
            for (Map.Entry entry : missingKeysPerLocale.entries()) {
                locale2 = (Locale)entry.getKey();
                String missingKey = (String)entry.getValue();
                this.getLog().warn((CharSequence)("bundle " + this.artifactId + " for locale " + locale2 + " misses key " + missingKey));
            }
        } else {
            for (Map.Entry entry : missingKeysPerLocale.asMap().entrySet()) {
                locale2 = (Locale)entry.getKey();
                int numberOfMissingKeys = ((Collection)entry.getValue()).size();
                this.getLog().warn((CharSequence)("bundle " + this.artifactId + " for locale " + locale2 + " misses " + numberOfMissingKeys + " keys! (use -Di18n.showMissing to see these entries)"));
            }
        }
        if (this.failsIfWarning && bundleValidation.isFail()) {
            throw new MojoFailureException("Bundles validation failed, see warning above for details about how to fix");
        }
    }
}

