/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SwitchoverBlueGreenDeploymentResponse extends RdsResponse implements
        ToCopyableBuilder<SwitchoverBlueGreenDeploymentResponse.Builder, SwitchoverBlueGreenDeploymentResponse> {
    private static final SdkField<BlueGreenDeployment> BLUE_GREEN_DEPLOYMENT_FIELD = SdkField
            .<BlueGreenDeployment> builder(MarshallingType.SDK_POJO).memberName("BlueGreenDeployment")
            .getter(getter(SwitchoverBlueGreenDeploymentResponse::blueGreenDeployment))
            .setter(setter(Builder::blueGreenDeployment)).constructor(BlueGreenDeployment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueGreenDeployment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUE_GREEN_DEPLOYMENT_FIELD));

    private final BlueGreenDeployment blueGreenDeployment;

    private SwitchoverBlueGreenDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.blueGreenDeployment = builder.blueGreenDeployment;
    }

    /**
     * Returns the value of the BlueGreenDeployment property for this object.
     * 
     * @return The value of the BlueGreenDeployment property for this object.
     */
    public final BlueGreenDeployment blueGreenDeployment() {
        return blueGreenDeployment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(blueGreenDeployment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SwitchoverBlueGreenDeploymentResponse)) {
            return false;
        }
        SwitchoverBlueGreenDeploymentResponse other = (SwitchoverBlueGreenDeploymentResponse) obj;
        return Objects.equals(blueGreenDeployment(), other.blueGreenDeployment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SwitchoverBlueGreenDeploymentResponse").add("BlueGreenDeployment", blueGreenDeployment())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlueGreenDeployment":
            return Optional.ofNullable(clazz.cast(blueGreenDeployment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SwitchoverBlueGreenDeploymentResponse, T> g) {
        return obj -> g.apply((SwitchoverBlueGreenDeploymentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SwitchoverBlueGreenDeploymentResponse> {
        /**
         * Sets the value of the BlueGreenDeployment property for this object.
         *
         * @param blueGreenDeployment
         *        The new value for the BlueGreenDeployment property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueGreenDeployment(BlueGreenDeployment blueGreenDeployment);

        /**
         * Sets the value of the BlueGreenDeployment property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BlueGreenDeployment.Builder} avoiding the
         * need to create one manually via {@link BlueGreenDeployment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlueGreenDeployment.Builder#build()} is called immediately and
         * its result is passed to {@link #blueGreenDeployment(BlueGreenDeployment)}.
         * 
         * @param blueGreenDeployment
         *        a consumer that will call methods on {@link BlueGreenDeployment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blueGreenDeployment(BlueGreenDeployment)
         */
        default Builder blueGreenDeployment(Consumer<BlueGreenDeployment.Builder> blueGreenDeployment) {
            return blueGreenDeployment(BlueGreenDeployment.builder().applyMutation(blueGreenDeployment).build());
        }
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private BlueGreenDeployment blueGreenDeployment;

        private BuilderImpl() {
        }

        private BuilderImpl(SwitchoverBlueGreenDeploymentResponse model) {
            super(model);
            blueGreenDeployment(model.blueGreenDeployment);
        }

        public final BlueGreenDeployment.Builder getBlueGreenDeployment() {
            return blueGreenDeployment != null ? blueGreenDeployment.toBuilder() : null;
        }

        public final void setBlueGreenDeployment(BlueGreenDeployment.BuilderImpl blueGreenDeployment) {
            this.blueGreenDeployment = blueGreenDeployment != null ? blueGreenDeployment.build() : null;
        }

        @Override
        public final Builder blueGreenDeployment(BlueGreenDeployment blueGreenDeployment) {
            this.blueGreenDeployment = blueGreenDeployment;
            return this;
        }

        @Override
        public SwitchoverBlueGreenDeploymentResponse build() {
            return new SwitchoverBlueGreenDeploymentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
