
zul.med.Audio = zk.$extends(zul.Widget, {
	$define: {
		src: function () {
			this.rerender(); //At least IE failed if change n.src only
		},
		align: function (v) {
			var n = this.$n();
			if (n) n.align = v || '';
		},
		border: function (v) {
			var n = this.$n();
			if (n) n.border = v || '';
		},
		autostart: function (v) {
			var n = this.$n();
			if (n) n.autostart = v;
		},
		loop: function (v) {
			var n = this.$n();
			if (n) n.loop = v;
		}
	},

	play: function () {
		var n = this.$n();
		if (n) {
			try { //Note: we cannot do "if (n.play)" in IE
				n.play();
			} catch (e) {
				try {
					n.Play(); //Firefox
				} catch (e) {
					jq.alert(msgzul.NO_AUDIO_SUPPORT+'\n'+e.message);
				}
			}
		}
	},

	stop: function (silent) {
		var n = this.$n();
		if (n) {
			try { //Note: we cannot do "if (n.stop)" in IE
				n.stop();
			} catch (e) {
				try {
					n.Stop();
				} catch (e) {
					if (!silent)
						jq.alert(msgzul.NO_AUDIO_SUPPORT+'\n'+e.message);
				}
			}
		}
	},

	pause: function () {
		var n = this.$n();
		if (n) {
			try { //Note: we cannot do "if (n.pause)" in IE
				n.pause();
			} catch (e) {
				try {
					n.Pause();
				} catch (e) {
					jq.alert(msgzul.NO_AUDIO_SUPPORT+'\n'+e.message);
				}
			}
		}
	},

	unbind_: function () {
		this.stop(true);
		this.$supers('unbind_', arguments);
	},

	domAttrs_: function(no){
		var attr = this.$supers('domAttrs_', arguments)
				+ ' src="' + (this._src || '') + '" z_autohide="true"',
			v;
		if (v = this._align) 
			attr += ' align="' + v + '"';
		if (v = this._border) 
			attr += ' border="' + v + '"';
		if (v = this._autostart) 
			attr += ' autostart="' + v + '"';
		if (v = this._loop) 
			attr += ' loop="' + v + '"';
		return attr;
	}
});
