/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.FormatInputElement;
import org.zkoss.zul.mesg.MZul;

public class Timebox
extends FormatInputElement
implements org.zkoss.zul.api.Timebox {
    private TimeZone _tzone;
    private boolean _btnVisible = true;

    public Timebox() {
        this.setCols(5);
        this.setFormat("HH:mm");
    }

    public Timebox(Date date) throws WrongValueException {
        this();
        this.setValue(date);
    }

    public void setFormat(String format) throws WrongValueException {
        if (format == null || format.length() == 0) {
            format = "HH:mm";
        }
        super.setFormat(format);
    }

    public Date getValue() throws WrongValueException {
        return (Date)this.getTargetValue();
    }

    public void setValue(Date value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    public boolean isButtonVisible() {
        return this._btnVisible;
    }

    public void setButtonVisible(boolean visible) {
        if (this._btnVisible != visible) {
            this._btnVisible = visible;
            this.smartUpdate("buttonVisible", visible);
        }
    }

    public TimeZone getTimeZone() {
        return this._tzone;
    }

    public void setTimeZone(TimeZone tzone) {
        this._tzone = tzone;
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        Date date;
        if (value == null || value.length() == 0) {
            return null;
        }
        String fmt = this.getFormat();
        DateFormat df = this.getDateFormat(fmt);
        try {
            date = df.parse(value);
        }
        catch (ParseException ex) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.DATE_REQUIRED, new Object[]{value, fmt}));
        }
        return date;
    }

    protected String coerceToString(Object value) {
        DateFormat df = this.getDateFormat(this.getFormat());
        return value != null ? df.format((Date)value) : "";
    }

    protected DateFormat getDateFormat(String fmt) {
        SimpleDateFormat df = new SimpleDateFormat(fmt, Locales.getCurrent());
        TimeZone tz = this._tzone != null ? this._tzone : TimeZones.getCurrent();
        df.setTimeZone(tz);
        return df;
    }

    public String getZclass() {
        return this._zclass == null ? "z-timebox" : this._zclass;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!this._btnVisible) {
            renderer.render("buttonVisible", this._btnVisible);
        }
    }
}

