/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.CheckEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.DeferredValue;
import org.zkoss.zul.Menubar;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.impl.LabelImageElement;

public class Menuitem
extends LabelImageElement
implements org.zkoss.zul.api.Menuitem {
    private String _value = "";
    private String _href;
    private String _target;
    private boolean _autocheck;
    private boolean _checked;
    private boolean _disabled = false;
    private boolean _checkmark;
    private String _upload;

    public Menuitem() {
    }

    public Menuitem(String label) {
        super(label);
    }

    public Menuitem(String label, String src) {
        super(label, src);
    }

    public final boolean isCheckmark() {
        return this._checkmark;
    }

    public void setCheckmark(boolean checkmark) {
        if (this._checkmark != checkmark) {
            this._checkmark = checkmark;
            this.smartUpdate("checkmark", checkmark);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-menu-item" : this._zclass;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", disabled);
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (!this._value.equals(value)) {
            this._value = value;
            this.smartUpdate("value", value);
        }
    }

    public boolean isChecked() {
        return this._checked;
    }

    public void setChecked(boolean checked) {
        if (this._checked != checked) {
            this._checked = checked;
            if (this._checked) {
                this._checkmark = true;
            }
            this.smartUpdate("checked", checked);
        }
    }

    public boolean isAutocheck() {
        return this._autocheck;
    }

    public void setAutocheck(boolean autocheck) {
        if (this._autocheck != autocheck) {
            this._autocheck = autocheck;
            this.smartUpdate("autocheck", autocheck);
        }
    }

    public String getHref() {
        return this._href;
    }

    public void setHref(String href) throws WrongValueException {
        if (href != null && href.length() == 0) {
            href = null;
        }
        if (!Objects.equals((Object)this._href, (Object)href)) {
            this._href = href;
            this.smartUpdate("href", new EncodedHref());
        }
    }

    public String getTarget() {
        return this._target;
    }

    public void setTarget(String target) {
        if (target != null && target.length() == 0) {
            target = null;
        }
        if (!Objects.equals((Object)this._target, (Object)target)) {
            this._target = target;
            this.smartUpdate("target", this._target);
        }
    }

    public boolean isTopmost() {
        return !(this.getParent() instanceof Menupopup);
    }

    public String getUpload() {
        return this._upload;
    }

    public void setUpload(String upload) {
        if (upload != null && (upload.length() == 0 || "false".equals(upload))) {
            upload = null;
        }
        if (!Objects.equals((Object)upload, (Object)this._upload)) {
            this._upload = upload;
            this.smartUpdate("upload", this._upload);
        }
    }

    private String getEncodedHref() {
        Desktop dt = this.getDesktop();
        return this._href != null && dt != null ? dt.getExecution().encodeURL(this._href) : null;
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Menupopup) && !(parent instanceof Menubar)) {
            throw new UiException("Unsupported parent for menuitem: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    protected boolean isChildable() {
        return false;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._checkmark) {
            this.render(renderer, "checkmark", this._checkmark);
        }
        if (this._disabled) {
            this.render(renderer, "disabled", this._disabled);
        }
        if (this._checked) {
            this.render(renderer, "checked", this._checked);
        }
        if (this._autocheck) {
            this.render(renderer, "autocheck", this._autocheck);
        }
        if (this._href != null) {
            this.render(renderer, "href", this.getEncodedHref());
        }
        if (this._target != null) {
            this.render(renderer, "target", this._target);
        }
        this.render(renderer, "upload", this._upload);
        this.render(renderer, "value", this._value);
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onCheck")) {
            CheckEvent evt = CheckEvent.getCheckEvent((AuRequest)request);
            this._checked = evt.isChecked();
            if (this._checked) {
                this._checkmark = true;
            }
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    static {
        Menuitem.addClientEvent((Class)Menuitem.class, (String)"onCheck", (int)1);
    }

    private class EncodedHref
    implements DeferredValue {
        private EncodedHref() {
        }

        public Object getValue() {
            return Menuitem.this.getEncodedHref();
        }
    }
}

