/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.io.Files;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.mesg.Messages;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.Includer;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.HtmlPageRenders;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.impl.XulElement;
import org.zkoss.zul.mesg.MZul;

public class Include
extends XulElement
implements org.zkoss.zul.api.Include,
Includer {
    private static final Log log = Log.lookup((Class)Include.class);
    private String _src;
    private Map _dynams;
    private transient Page _childpg;
    private String _mode = Include.getDefaultMode();
    private boolean _localized;
    private boolean _progressing;
    private boolean _afterComposed;
    private boolean _instantMode;
    private boolean _comment;
    private byte _progressStatus;
    private static String _defMode;

    public Include() {
    }

    public Include(String src) {
        this.setSrc(src);
    }

    public void setProgressing(boolean progressing) {
        if (this._progressing != progressing) {
            if (progressing && "instant".equals(this._mode)) {
                throw new UnsupportedOperationException("progressing not allowed in instant mode");
            }
            this._progressing = progressing;
            if (this._progressing) {
                this.fixMode();
            }
            this.checkProgressing();
        }
    }

    public boolean getProgressing() {
        return this._progressing;
    }

    public void onEchoInclude() {
        Clients.showBusy(null, (boolean)false);
        super.invalidate();
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (!Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this.fixMode();
            if (!this._instantMode) {
                this.invalidate();
            }
        }
    }

    public String getMode() {
        return this._mode;
    }

    public void setMode(String mode) throws WrongValueException {
        if (!this._mode.equals(mode)) {
            if (!("auto".equals(mode) || "instant".equals(mode) || "defer".equals(mode))) {
                throw new WrongValueException("Unknown mode: " + mode);
            }
            if ((this._localized || this._progressing) && "instant".equals(mode)) {
                throw new UnsupportedOperationException("localized/progressing not allowed in instant mold");
            }
            this._mode = mode;
            this.fixMode();
        }
    }

    private void fixMode() {
        this.fixModeOnly();
        if (this._instantMode && this._afterComposed) {
            this.afterCompose();
        }
    }

    private void fixModeOnly() {
        boolean oldInstantMode = this._instantMode;
        this._instantMode = "auto".equals(this._mode) ? (this._src != null && !this._progressing && !this._localized ? this._src.endsWith(".zul") || this._src.endsWith(".zhtml") : false) : "instant".equals(this._mode);
        this.getChildren().clear();
        if (this._instantMode != oldInstantMode) {
            this.invalidate();
        }
    }

    public final boolean isLocalized() {
        return this._localized;
    }

    public final void setLocalized(boolean localized) {
        if (this._localized != localized) {
            if (localized && "instant".equals(this._mode)) {
                throw new UnsupportedOperationException("localized not supported in instant mode yet");
            }
            this._localized = localized;
            if (this._localized) {
                this.fixMode();
            }
            if (!this._instantMode) {
                this.invalidate();
            }
        }
    }

    public boolean isComment() {
        return this._comment;
    }

    public void setComment(boolean comment) {
        this._comment = comment;
    }

    public Page getChildPage() {
        return this._childpg;
    }

    public void setChildPage(Page page) {
        Desktop desktop;
        if (this._childpg != null && page == null && (desktop = this.getDesktop()) != null) {
            ((DesktopCtrl)desktop).removePage(this._childpg);
        }
        this._childpg = page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompose() {
        this._afterComposed = true;
        this.fixModeOnly();
        if (this._instantMode) {
            Execution exec = this.getDesktop().getExecution();
            Map old = this.setupDynams(exec);
            try {
                int j = this._src.indexOf(63);
                exec.createComponents(j >= 0 ? this._src.substring(0, j) : this._src, (Component)this, null);
            }
            finally {
                Include.restoreDynams(exec, old);
            }
        }
    }

    public boolean hasDynamicProperty(String name) {
        return this._dynams != null && this._dynams.containsKey(name);
    }

    public Object getDynamicProperty(String name) {
        return this._dynams != null ? this._dynams.get(name) : null;
    }

    public void setDynamicProperty(String name, Object value) {
        if (this._dynams == null) {
            this._dynams = new HashMap();
        }
        this._dynams.put(name, value);
    }

    public void invalidate() {
        super.invalidate();
        if (this._progressStatus >= 2) {
            this._progressStatus = 0;
        }
        this.checkProgressing();
    }

    private void checkProgressing() {
        if (this._progressing && this._progressStatus == 0) {
            this._progressStatus = 1;
            Clients.showBusy((String)Messages.get((int)MZul.PLEASE_WAIT), (boolean)true);
            Events.echoEvent((String)"onEchoInclude", (Component)this, null);
        }
    }

    protected boolean isChildable() {
        return this._instantMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void redrawChildren(Writer out) throws IOException {
        this.setChildPage(null);
        if (this._instantMode) {
            super.redrawChildren(out);
            return;
        }
        UiEngine ueng = ((WebAppCtrl)this.getDesktop().getWebApp()).getUiEngine();
        Component old = ueng.setOwner((Component)this);
        try {
            if (this._progressStatus == 1) {
                this._progressStatus = (byte)2;
            } else if (this._src != null && this._src.length() > 0) {
                StringWriter sw = new StringWriter();
                this.include(sw);
                if (this.getChildPage() != null) {
                    Files.write((Writer)out, (StringBuffer)sw.getBuffer());
                } else {
                    boolean done = false;
                    HtmlPageRenders.RenderContext rc = HtmlPageRenders.getRenderContext(null);
                    if (rc != null && rc.crawlable) {
                        rc.extra.write("<div id=\"");
                        rc.extra.write(this.getUuid());
                        rc.extra.write("\">");
                        if (this._comment) {
                            rc.extra.write("\n<!--\n");
                        }
                        Files.write((Writer)rc.extra, (StringBuffer)sw.getBuffer());
                        if (this._comment) {
                            rc.extra.write("\n-->\n");
                        }
                        rc.extra.write("</div>");
                        out.write("zk.mnt.top().props.z_ea='content';");
                        done = true;
                    }
                    if (!done) {
                        out.write("zk.mnt.top().props.content='");
                        StringBuffer sb = new StringBuffer(1024);
                        Strings.escape((StringBuffer)sb, (CharSequence)sw.getBuffer(), (String)"'\n\r\t\f\\/");
                        Files.write((Writer)out, (StringBuffer)sb);
                        out.write("';");
                    }
                }
            }
        }
        finally {
            ueng.setOwner(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void include(Writer out) throws IOException {
        desktop = this.getDesktop();
        exec = desktop.getExecution();
        src = exec.toAbsoluteURI(this._src, false);
        old = this.setupDynams(exec);
        try {
            exec.include(out, src, null, 0);
        }
        catch (Throwable err) {
            this.setChildPage(null);
            errpg = desktop.getWebApp().getConfiguration().getErrorPage(desktop.getDeviceType(), err);
            if (errpg == null) ** GOTO lbl-1000
            try {
                exec.setAttribute("javax.servlet.error.message", (Object)Exceptions.getMessage((Throwable)err));
                exec.setAttribute("javax.servlet.error.exception", (Object)err);
                exec.setAttribute("javax.servlet.error.exception_type", err.getClass());
                exec.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
                exec.include(out, errpg, null, 0);
                return;
            }
            catch (IOException ex) {
            }
            catch (Throwable ex) {
                Include.log.warning("Failed to load the error page: " + errpg, ex);
            }
lbl-1000:
            // 3 sources

            {
                msg = Messages.get((int)MZk.PAGE_FAILED, (Object[])new Object[]{src, Exceptions.getMessage((Throwable)err), Exceptions.formatStackTrace(null, (Throwable)err, null, (int)6)});
                attrs = new HashMap<String, String>();
                attrs.put("px_alert_type", "error");
                attrs.put("px_alert", msg);
                exec.include(out, "~./html/alert.dsp", attrs, 3);
            }
        }
        finally {
            Include.restoreDynams(exec, old);
        }
    }

    private Map setupDynams(Execution exec) {
        if (this._dynams == null || this._dynams.isEmpty()) {
            return null;
        }
        HashMap<String, Object> old = new HashMap<String, Object>();
        Iterator it = this._dynams.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            String nm = (String)me.getKey();
            Object val = me.getValue();
            old.put(nm, exec.getAttribute(nm));
            if (val != null) {
                exec.setAttribute(nm, val);
                continue;
            }
            exec.removeAttribute(nm);
        }
        return old;
    }

    private static void restoreDynams(Execution exec, Map old) {
        if (old != null) {
            Iterator it = old.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                String nm = (String)me.getKey();
                Object val = me.getValue();
                if (val != null) {
                    exec.setAttribute(nm, val);
                    continue;
                }
                exec.removeAttribute(nm);
            }
        }
    }

    private static String getDefaultMode() {
        if (_defMode == null) {
            _defMode = Library.getProperty((String)"org.zkoss.zul.include.mode", (String)"auto");
        }
        return _defMode;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._comment) {
            renderer.render("comment", true);
        }
    }
}

