/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Caption;
import org.zkoss.zul.impl.XulElement;

public class Groupbox
extends XulElement
implements org.zkoss.zul.api.Groupbox {
    private transient Caption _caption;
    private String _cntStyle;
    private String _cntSclass;
    private Boolean _legend;
    private boolean _open = true;
    private boolean _closable = true;

    public Caption getCaption() {
        return this._caption;
    }

    public org.zkoss.zul.api.Caption getCaptionApi() {
        return this.getCaption();
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            this.smartUpdate("open", this._open);
        }
    }

    public boolean isClosable() {
        return this._closable;
    }

    public void setClosable(boolean closable) {
        if (this._closable != closable) {
            this._closable = closable;
            this.smartUpdate("closable", closable);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "contentStyle", this._cntStyle);
        this.render(renderer, "contentSclass", this._cntSclass);
        if (!this._open) {
            renderer.render("open", false);
        }
        if (!this._closable) {
            renderer.render("closable", false);
        }
    }

    public String getZclass() {
        return this._zclass == null ? (this.isLegend() ? "z-fieldset" : "z-groupbox") : this._zclass;
    }

    public String getContentStyle() {
        return this._cntStyle;
    }

    public void setContentStyle(String style) {
        if (!Objects.equals((Object)this._cntStyle, (Object)style)) {
            this._cntStyle = style;
            this.smartUpdate("contentStyle", this._cntStyle);
        }
    }

    public String getContentSclass() {
        return this._cntSclass;
    }

    public void setContentSclass(String scls) {
        if (!Objects.equals((Object)this._cntSclass, (Object)scls)) {
            this._cntSclass = scls;
            this.smartUpdate("contentSclass", this._cntSclass);
        }
    }

    public boolean isLegend() {
        return this._legend != null ? this._legend.booleanValue() : "default".equals(this.getMold());
    }

    public void setLegend(boolean legend) {
        this._legend = legend;
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (child instanceof Caption) {
            if (this._caption != null && this._caption != child) {
                throw new UiException("Only one caption is allowed: " + this);
            }
        } else if (refChild instanceof Caption) {
            throw new UiException("caption must be the first child");
        }
        super.beforeChildAdded(child, refChild);
    }

    public boolean insertBefore(Component child, Component refChild) {
        if (child instanceof Caption) {
            refChild = this.getFirstChild();
            if (super.insertBefore(child, refChild)) {
                this._caption = (Caption)child;
                return true;
            }
        } else {
            return super.insertBefore(child, refChild);
        }
        return false;
    }

    public void onChildRemoved(Component child) {
        if (child instanceof Caption) {
            this._caption = null;
        }
        super.onChildRemoved(child);
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onOpen")) {
            OpenEvent evt = OpenEvent.getOpenEvent((AuRequest)request);
            this._open = evt.isOpen();
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    public Object clone() {
        Groupbox clone = (Groupbox)super.clone();
        if (this._caption != null) {
            clone.afterUnmarshal();
        }
        return clone;
    }

    private void afterUnmarshal() {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (!(child instanceof Caption)) continue;
            this._caption = (Caption)child;
            break;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.afterUnmarshal();
    }

    static {
        Groupbox.addClientEvent((Class)Groupbox.class, (String)"onOpen", (int)1);
    }
}

