/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.math.BigDecimal;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.impl.NumberInputElement;
import org.zkoss.zul.mesg.MZul;

public class Decimalbox
extends NumberInputElement
implements org.zkoss.zul.api.Decimalbox {
    public static final int AUTO = -1000000000;
    private int _scale = -1000000000;

    public Decimalbox() {
        this.setCols(11);
    }

    public Decimalbox(BigDecimal value) throws WrongValueException {
        this();
        this.setValue(value);
    }

    public BigDecimal getValue() throws WrongValueException {
        return (BigDecimal)this.getTargetValue();
    }

    public double doubleValue() throws WrongValueException {
        BigDecimal val = this.getValue();
        return val != null ? val.doubleValue() : 0.0;
    }

    public int intValue() throws WrongValueException {
        BigDecimal val = this.getValue();
        return val != null ? val.intValue() : 0;
    }

    public long longValue() throws WrongValueException {
        BigDecimal val = this.getValue();
        return val != null ? val.longValue() : 0L;
    }

    public short shortValue() throws WrongValueException {
        BigDecimal val = this.getValue();
        return val != null ? val.shortValue() : (short)0;
    }

    public void setValue(BigDecimal value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    public void setValue(String str) {
        this.setValue(new BigDecimal(str));
    }

    public int getScale() {
        return this._scale;
    }

    public void setScale(int scale) {
        this._scale = scale;
    }

    public String getZclass() {
        return this._zclass == null ? "z-decimalbox" : this._zclass;
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        Object[] vals = this.toNumberOnly(value);
        String val = (String)vals[0];
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            int divscale;
            BigDecimal v = new BigDecimal(val);
            if (this._scale != -1000000000) {
                v = v.setScale(this._scale, this.getRoundingMode());
            }
            int n = divscale = vals[1] != null ? (Integer)vals[1] : 0;
            if (divscale > 0) {
                BigDecimal ten = new BigDecimal(10);
                do {
                    v = v.divide(ten, this._scale == -1000000000 ? v.scale() + 1 : this._scale, this.getRoundingMode());
                } while (--divscale > 0);
            }
            return v;
        }
        catch (NumberFormatException ex) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.NUMBER_REQUIRED, (Object)value));
        }
    }

    protected String coerceToString(Object value) {
        return value != null && this.getFormat() == null ? value.toString() : this.formatNumber(value, null);
    }
}

