/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.DeferredValue;
import org.zkoss.zul.impl.LabelImageElement;

public class Button
extends LabelImageElement
implements org.zkoss.zul.api.Button {
    private String _orient = "horizontal";
    private String _dir = "normal";
    private String _href;
    private String _target;
    private String _autodisable;
    protected String _upload;
    private int _tabindex = -1;
    private boolean _disabled;

    public Button() {
    }

    public Button(String label) {
        super(label);
    }

    public Button(String label, String image) {
        super(label, image);
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public String getAutodisable() {
        return this._autodisable;
    }

    public void setAutodisable(String autodisable) {
        if (this._autodisable != autodisable) {
            this._autodisable = autodisable;
            this.smartUpdate("autodisable", autodisable);
        }
    }

    public String getDir() {
        return this._dir;
    }

    public void setDir(String dir) throws WrongValueException {
        if (!"normal".equals(dir) && !"reverse".equals(dir)) {
            throw new WrongValueException(dir);
        }
        if (!Objects.equals((Object)this._dir, (Object)dir)) {
            this._dir = dir;
            this.smartUpdate("dir", this._dir);
        }
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException(orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
        }
    }

    public String getHref() {
        return this._href;
    }

    public void setHref(String href) {
        if (href != null && href.length() == 0) {
            href = null;
        }
        if (!Objects.equals((Object)this._href, (Object)href)) {
            this._href = href;
            this.smartUpdate("href", new EncodedHref());
        }
    }

    public String getTarget() {
        return this._target;
    }

    public void setTarget(String target) {
        if (target != null && target.length() == 0) {
            target = null;
        }
        if (!Objects.equals((Object)this._target, (Object)target)) {
            this._target = target;
            this.smartUpdate("target", this._target);
        }
    }

    public int getTabindex() {
        return this._tabindex;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        if (this._tabindex != tabindex) {
            this._tabindex = tabindex;
            this.smartUpdate("tabindex", this._tabindex);
        }
    }

    public String getUpload() {
        return this._upload;
    }

    public void setUpload(String upload) {
        if (upload != null && (upload.length() == 0 || "false".equals(upload))) {
            upload = null;
        }
        if (upload != null && !"trendy".equals(this.getMold()) && this.getDefinition().getMoldNames().contains("trendy")) {
            this.setMold("trendy");
        }
        if (!Objects.equals((Object)upload, (Object)this._upload)) {
            this._upload = upload;
            this.smartUpdate("upload", this._upload);
        }
    }

    private String getEncodedHref() {
        Desktop dt = this.getDesktop();
        return this._href != null && dt != null ? dt.getExecution().encodeURL(this._href) : null;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._tabindex >= 0) {
            renderer.render("tabindex", this._tabindex);
        }
        if (!"normal".equals(this._dir)) {
            this.render(renderer, "dir", this._dir);
        }
        if (!"horizontal".equals(this._orient)) {
            this.render(renderer, "orient", this._orient);
        }
        this.render(renderer, "disabled", this._disabled);
        this.render(renderer, "autodisable", this._autodisable);
        this.render(renderer, "href", this.getEncodedHref());
        this.render(renderer, "target", this._target);
        this.render(renderer, "upload", this._upload);
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : (!"trendy".equals(this.getMold()) ? "z-button-os" : "z-button");
    }

    protected boolean isChildable() {
        return false;
    }

    static {
        Button.addClientEvent((Class)Button.class, (String)"onFocus", (int)8192);
        Button.addClientEvent((Class)Button.class, (String)"onBlur", (int)8192);
    }

    private class EncodedHref
    implements DeferredValue {
        private EncodedHref() {
        }

        public Object getValue() {
            return Button.this.getEncodedHref();
        }
    }
}

