/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.io.Serializables;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.event.ChartDataEvent;
import org.zkoss.zul.event.ChartDataListener;

public abstract class AbstractChartModel
implements ChartModel,
Serializable {
    private transient List _listeners = new LinkedList();

    protected void fireEvent(int type, Comparable series, Object data) {
        ChartDataEvent evt = new ChartDataEvent(this, type, series, data);
        Iterator it = this._listeners.iterator();
        while (it.hasNext()) {
            ((ChartDataListener)it.next()).onChange(evt);
        }
    }

    public void addChartDataListener(ChartDataListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this._listeners.add(l);
    }

    public void removeChartDataListener(ChartDataListener l) {
        this._listeners.remove(l);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Serializables.smartWrite((ObjectOutputStream)s, (Collection)this._listeners);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._listeners = new LinkedList();
        Serializables.smartRead((ObjectInputStream)s, (Collection)this._listeners);
    }
}

