zk.load("zul.zul");
zk.Slider=Class.create();
zk.Slider.prototype={initialize:function(_1){
this.id=_1.id;
zkau.setMeta(_1,this);
this.init();
},cleanup:function(){
if(this.draggable){
this.draggable.destroy();
this.draggable.slider=null;
this.draggable=null;
}
},init:function(){
this.cleanup();
this.element=$e(this.id);
if(!this.element){
return;
}
this.button=$e(this.id+"!btn");
var _2=this;
var _3=function(x,y){
return _2._snap(x,y);
};
this.draggable=new Draggable(this.button,{constraint:"horizontal",snap:_3,starteffect:zkSld._startDrag,change:zkSld._dragging,endeffect:zkSld._endDrag});
if(zk.gecko&&!this.button.complete){
this.button.onload=function(){
_2._fixPos();
};
}
this._fixPos();
},_snap:function(x,y){
var _8=Position.cumulativeOffset(this.element);
_8=zk.toStylePos(this.button,_8[0],_8[1]);
if(x<=_8[0]){
x=_8[0];
}else{
var _9=_8[0]+this._width();
if(x>_9){
x=_9;
}
}
if(y<=_8[1]){
y=_8[1];
}else{
var _9=_8[1]+this.element.clientHeight;
if(y>_9){
y=_9;
}
}
return [x,y];
},_fixPos:function(){
var wd=this._width();
var x=wd>0?Math.round((this._curpos()*wd)/this._maxpos()):0;
var _c=Position.cumulativeOffset(this.element);
_c=zk.toStylePos(this.button,_c[0],_c[1]);
_c=this._snap(_c[0]+x,0);
this.button.style.left=_c[0]+"px";
},_startDrag:function(){
this.button.title="";
this.slidepos=this._curpos();
document.body.insertAdjacentHTML("beforeend","<div id=\"zul_slidetip\" style=\"position:absolute;display:none;z-index:60000;background-color:white;border: 1px outset\">"+this.slidepos+"</div>");
this.slidetip=$e("zul_slidetip");
if(this.slidetip){
this.slidetip.style.display="block";
zk.position(this.slidetip,this.element,"after-start");
}
},_dragging:function(){
var _d=this._realpos();
if(_d!=this.slidepos){
this.slidepos=_d;
if(this.slidetip){
this.slidetip.innerHTML=_d;
}
if(getZKAttr(this.element,"onScrolling")){
zkau.send({uuid:this.element.id,cmd:"onScrolling",data:[_d],implicit:true},0);
}
}
},_endDrag:function(){
var _e=this._realpos();
var _f=this._curpos();
if(_e!=_f){
setZKAttr(this.element,"curpos",_e);
zkau.send({uuid:this.element.id,cmd:"onScroll",data:[_e]},zkau.asapTimeout(this.element,"onScroll"));
}
this._fixPos();
this.button.title=_e;
if(this.slidetip){
Element.remove(this.slidetip);
this.slidetip=null;
}
},_realpos:function(){
var _10=Position.cumulativeOffset(this.button);
var _11=Position.cumulativeOffset(this.element);
var _12=this._maxpos();
var wd=this._width();
var pos=wd?Math.round(((_10[0]-_11[0])*_12)/wd):0;
return pos>=0?pos:0;
},_curpos:function(){
return parseInt(getZKAttr(this.element,"curpos"));
},_maxpos:function(){
return parseInt(getZKAttr(this.element,"maxpos"));
},_width:function(){
return this.element.clientWidth-this.button.offsetWidth;
}};
zkSld={};
zkSld.init=function(cmp){
var _16=zkau.getMeta(cmp);
if(_16){
_16.init();
}else{
new zk.Slider(cmp);
}
};
zkSld.cleanup=zkau.cleanupMeta;
zkSld._startDrag=function(_17){
var _18=zkSld._metaByBtn(_17);
return _18?_18._startDrag():null;
};
zkSld._endDrag=function(_19){
var _1a=zkSld._metaByBtn(_19);
return _1a?_1a._endDrag():null;
};
zkSld._dragging=function(_1b){
var _1c=zkSld._metaByBtn(_1b.element);
return _1c?_1c._dragging():null;
};
zkSld._metaByBtn=function(_1d){
var _1e=_1d.id;
return zkau.getMeta(_1e.substring(0,_1e.length-4));
};
zkSld.setAttr=function(cmp,nm,val){
if("z:curpos"==nm){
setZKAttr(cmp,"curpos",val);
var _22=zkau.getMeta(cmp);
if(_22){
_22._fixPos();
}
return true;
}
return false;
};

