/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import org.zkoss.lang.Objects;
import org.zkoss.mesg.MCommon;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.au.AuDoOverlapped;
import org.zkoss.zk.au.AuDoPopup;
import org.zkoss.zk.au.AuEndOverlapped;
import org.zkoss.zk.au.AuEndPopup;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.render.MultiBranch;
import org.zkoss.zul.Caption;
import org.zkoss.zul.au.AuDoModal;
import org.zkoss.zul.au.AuEndModal;
import org.zkoss.zul.impl.XulElement;

public class Window
extends XulElement
implements IdSpace {
    private transient Caption _caption;
    private String _border = "none";
    private String _title = "";
    private String _ctrlKeys;
    private String _ctkeys;
    private int _mode = 0;
    private transient Object _mutex;
    private boolean _moding;
    private boolean _closable;
    private static final int EMBEDDED = 0;
    private static final int MODAL = 1;
    private static final int OVERLAPPED = 2;
    private static final int POPUP = 3;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Window() {
        this.init();
    }

    public Window(String title, String border, boolean closable) {
        this();
        this.setTitle(title);
        this.setBorder(border);
        this.setClosable(closable);
    }

    private void init() {
        this._mutex = new Object();
    }

    public Caption getCaption() {
        return this._caption;
    }

    public String getBorder() {
        return this._border;
    }

    public void setBorder(String border) {
        if (border == null) {
            border = "none";
        }
        if (!Objects.equals((Object)this._border, (Object)border)) {
            this._border = border;
            this.smartUpdate("class", this.getSclass());
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        if (!Objects.equals((Object)this._title, (Object)title)) {
            this._title = title;
            if (this._caption != null) {
                this._caption.invalidate();
            } else {
                this.invalidate();
            }
        }
    }

    public String getCtrlKeys() {
        return this._ctrlKeys;
    }

    public void setCtrlKeys(String ctrlKeys) throws UiException {
        if (ctrlKeys != null && ctrlKeys.length() == 0) {
            ctrlKeys = null;
        }
        if (!Objects.equals((Object)this._ctrlKeys, (Object)ctrlKeys)) {
            this.parseCtrlKeys(ctrlKeys);
            this.smartUpdate("z:ctkeys", this._ctkeys);
        }
    }

    private void parseCtrlKeys(String keys) throws UiException {
        if (keys == null || keys.length() == 0) {
            this._ctkeys = null;
            this._ctrlKeys = null;
            return;
        }
        StringBuffer sbctl = new StringBuffer();
        StringBuffer sbsft = new StringBuffer();
        StringBuffer sbalt = new StringBuffer();
        StringBuffer sbext = new StringBuffer();
        StringBuffer sbcur = null;
        int len = keys.length();
        block6: for (int j = 0; j < len; ++j) {
            int cc = keys.charAt(j);
            switch (cc) {
                case 36: 
                case 64: 
                case 94: {
                    if (sbcur != null) {
                        throw new WrongValueException("Combination of Shift, Alt and Ctrl not supported: " + keys);
                    }
                    sbcur = cc == 94 ? sbctl : (cc == 64 ? sbalt : sbsft);
                    continue block6;
                }
                case 35: {
                    char c2;
                    int k;
                    for (k = j + 1; k < len && ((c2 = keys.charAt(k)) <= 'Z' && c2 >= 'A' || c2 <= 'z' && c2 >= 'a' || c2 <= '9' && c2 >= '0'); ++k) {
                    }
                    if (k == j + 1) {
                        throw new WrongValueException(MCommon.UNEXPECTED_CHARACTER, new Object[]{new Character((char)cc), keys});
                    }
                    String s = keys.substring(j + 1, k).toLowerCase();
                    if ("pgup".equals(s)) {
                        cc = 65;
                    } else if ("pgdn".equals(s)) {
                        cc = 66;
                    } else if ("end".equals(s)) {
                        cc = 67;
                    } else if ("home".equals(s)) {
                        cc = 68;
                    } else if ("left".equals(s)) {
                        cc = 69;
                    } else if ("up".equals(s)) {
                        cc = 70;
                    } else if ("right".equals(s)) {
                        cc = 71;
                    } else if ("down".equals(s)) {
                        cc = 72;
                    } else if ("ins".equals(s)) {
                        cc = 73;
                    } else if ("del".equals(s)) {
                        cc = 74;
                    } else if (s.length() > 1 && s.charAt(0) == 'f') {
                        int v;
                        try {
                            v = Integer.parseInt(s.substring(1));
                        }
                        catch (Throwable ex) {
                            throw new WrongValueException("Unknown #" + s + " in " + keys);
                        }
                        if (v == 0 || v > 12) {
                            throw new WrongValueException("Unsupported function key: #f" + v);
                        }
                        cc = (char)(79 + v);
                    } else {
                        throw new WrongValueException("Unknown #" + s + " in " + keys);
                    }
                    if (sbcur == null) {
                        sbext.append((char)cc);
                    } else {
                        sbcur.append((char)cc);
                        sbcur = null;
                    }
                    j = k - 1;
                    continue block6;
                }
                default: {
                    if (!(sbcur != null && (cc <= 90 && cc >= 65 || cc <= 122 && cc >= 97 || cc <= 57 && cc >= 48))) {
                        throw new WrongValueException(MCommon.UNEXPECTED_CHARACTER, new Object[]{new Character((char)cc), keys});
                    }
                    if (sbcur == sbsft) {
                        throw new WrongValueException("$" + (char)cc + " not supported: " + keys);
                    }
                    if (cc <= 90 && cc >= 65) {
                        cc = (char)(cc + 32);
                    }
                    sbcur.append((char)cc);
                    sbcur = null;
                }
            }
        }
        this._ctkeys = "" + '^' + sbctl + ';' + '@' + sbalt + ';' + '$' + sbsft + ';' + '#' + sbext + ';';
        this._ctrlKeys = keys;
    }

    public String getMode() {
        switch (this._mode) {
            case 1: {
                return "modal";
            }
            case 3: {
                return "popup";
            }
            case 2: {
                return "overlapped";
            }
        }
        return "embedded";
    }

    public void setMode(String name) throws InterruptedException {
        if ("popup".equals(name)) {
            this.doPopup();
        } else if ("overlapped".equals(name)) {
            this.doOverlapped();
        } else if ("embedded".equals(name)) {
            this.doEmbedded();
        } else if ("modal".equals(name)) {
            this.doModal();
        } else {
            throw new WrongValueException("Uknown mode: " + name);
        }
    }

    public boolean inModal() {
        return this._mode == 1;
    }

    public boolean inEmbedded() {
        return this._mode == 0;
    }

    public boolean inOverlapped() {
        return this._mode == 2;
    }

    public boolean inPopup() {
        return this._mode == 3;
    }

    public void doModal() throws InterruptedException {
        this.checkOverlappable();
        if (!Events.inEventListener()) {
            throw new WrongValueException("doModal() and setMode(\"modal\") can only be called in an event listener, not in page loading");
        }
        if (this._mode != 1 || !this._moding) {
            this.endModing();
            if (this._mode != 1) {
                this._mode = 1;
                this.invalidate();
            }
            this.response("doModal", new AuDoModal((Component)this));
            this._moding = true;
            this.setVisible(true);
            Executions.wait((Object)this._mutex);
        }
    }

    public void doOverlapped() {
        this.checkOverlappable();
        if (this._mode != 2 || !this._moding) {
            this.endModing();
            if (this._mode != 2) {
                this._mode = 2;
                this.invalidate();
            }
            this.response("doOverlapped", (AuResponse)new AuDoOverlapped((Component)this));
            this._moding = true;
            this.setVisible(true);
        }
    }

    public void doPopup() {
        this.checkOverlappable();
        if (this._mode != 3 || !this._moding) {
            this.endModing();
            if (this._mode != 3) {
                this._mode = 3;
                this.invalidate();
            }
            this.response("doPopup", (AuResponse)new AuDoPopup((Component)this));
            this._moding = true;
            this.setVisible(true);
        }
    }

    public void doEmbedded() {
        if (this._mode != 0) {
            this.endModing();
            this._mode = 0;
            this.invalidate();
        }
        this.setVisible(true);
    }

    private void checkOverlappable() {
        if (!"false".equals(this.getDraggable())) {
            throw new UiException("Draggable window cannot be modal, overlapped or popup: " + (Object)((Object)this));
        }
        Window comp = this;
        while ((comp = comp.getParent()) != null) {
            if (comp.isVisible()) continue;
            throw new UiException("One of its ancestors, " + (Object)((Object)comp) + ", is not visible, so unable to be modal, overlapped or popup");
        }
    }

    public boolean isClosable() {
        return this._closable;
    }

    public void setClosable(boolean closable) {
        if (this._closable != closable) {
            this._closable = closable;
            this.invalidate();
        }
    }

    public void onClose() {
        this.detach();
    }

    public void onModal() throws InterruptedException {
        this.doModal();
    }

    private void endModing() {
        if (this._moding) {
            if (!$assertionsDisabled && this._mode == 0) {
                throw new AssertionError();
            }
            if (this._mode == 1) {
                Executions.notifyAll((Object)this._mutex);
            }
            if (this._mode == 1) {
                this.response(null, new AuEndModal((Component)this));
            } else if (this._mode == 3) {
                this.response(null, (AuResponse)new AuEndPopup((Component)this));
            } else {
                this.response(null, (AuResponse)new AuEndOverlapped((Component)this));
            }
            this._moding = false;
        }
    }

    public String getSclass() {
        String scls = super.getSclass();
        if (scls != null) {
            return scls;
        }
        return "normal".equals(this.getBorder()) ? this.getMode() : this.getMode() + '-' + this.getBorder();
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (child instanceof Caption) {
            if (this._caption != null && this._caption != child) {
                throw new UiException("Only one caption is allowed: " + (Object)((Object)this));
            }
            if (!this.getChildren().isEmpty()) {
                insertBefore = (Component)this.getChildren().get(0);
            }
            this._caption = (Caption)child;
            this.invalidate();
        } else if (insertBefore instanceof Caption) {
            throw new UiException("caption must be the first child");
        }
        return super.insertBefore(child, insertBefore);
    }

    public void onChildRemoved(Component child) {
        if (child instanceof Caption) {
            this._caption = null;
            this.invalidate();
        }
        super.onChildRemoved(child);
    }

    public void setPage(Page page) {
        Page old = this.getPage();
        super.setPage(page);
        if (old != page && (old == null || page == null)) {
            this.fixMode(page != null);
        }
    }

    public void setParent(Component parent) {
        Component old = this.getParent();
        super.setParent(parent);
        if (old != parent && (old == null || parent == null)) {
            this.fixMode(parent != null);
        }
    }

    private void fixMode(boolean attached) {
        if (attached) {
            switch (this._mode) {
                case 2: {
                    this.doOverlapped();
                }
                case 3: {
                    this.doPopup();
                }
            }
        } else {
            this.endModing();
            if (this._mode == 1) {
                this._mode = 0;
            }
        }
    }

    public boolean setVisible(boolean visible) {
        boolean ret;
        if (!visible) {
            this.endModing();
        }
        if (!(ret = super.setVisible(visible)) && visible && !this._moding) {
            switch (this._mode) {
                case 1: {
                    try {
                        this.doModal();
                        return false;
                    }
                    catch (InterruptedException ex) {
                        throw UiException.Aide.wrap((Throwable)ex);
                    }
                }
                case 3: {
                    this.doPopup();
                    return false;
                }
                case 2: {
                    this.doOverlapped();
                    return false;
                }
            }
        }
        return ret;
    }

    public void setDraggable(String draggable) {
        if (this._mode != 0 && draggable != null && draggable.length() > 0 && !"false".equals(draggable)) {
            throw new UiException("Only embedded window could be draggable: " + (Object)((Object)this));
        }
        super.setDraggable(draggable);
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        this.appendAsapAttr(sb, "onMove");
        this.appendAsapAttr(sb, "onZIndex");
        this.appendAsapAttr(sb, "onOK");
        this.appendAsapAttr(sb, "onCancel");
        this.appendAsapAttr(sb, "onCtrlKey");
        String clkattrs = this.getAllOnClickAttrs(false);
        if (clkattrs != null) {
            sb.append(clkattrs);
        }
        if (this._closable) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z:closable", (boolean)true);
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z:ctkeys", (String)this._ctkeys);
        return sb.toString();
    }

    public Object clone() {
        Window clone = (Window)((Object)super.clone());
        clone.init();
        if (clone._caption != null) {
            clone.afterUnmarshal();
        }
        return clone;
    }

    private void afterUnmarshal() {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (!(child instanceof Caption)) continue;
            this._caption = (Caption)((Object)child);
            break;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        this.afterUnmarshal();
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    static {
        $assertionsDisabled = !Window.class.desiredAssertionStatus();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements MultiBranch {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Window.this);
        }

        public boolean inDifferentBranch(Component child) {
            return child instanceof Caption;
        }
    }
}

