/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treecol;
import org.zkoss.zul.Treecols;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;
import org.zkoss.zul.impl.LabelImageElement;

public class Treecell
extends LabelImageElement {
    private static final String ROOT_OPEN = "/root-open.gif";
    private static final String ROOT_CLOSE = "/root-close.gif";
    private static final String LAST_OPEN = "/last-open.gif";
    private static final String LAST_CLOSE = "/last-close.gif";
    private static final String TEE_OPEN = "/tee-open.gif";
    private static final String TEE_CLOSE = "/tee-close.gif";
    private static final String TEE = "/tee.gif";
    private static final String LAST = "/last.gif";
    private static final String VBAR = "/vbar.gif";
    private static final String SPACER = "/spacer.gif";

    public Treecell() {
    }

    public Treecell(String label) {
        this.setLabel(label);
    }

    public Treecell(String label, String src) {
        this.setLabel(label);
        this.setImage(src);
    }

    public Tree getTree() {
        Treecell n = this;
        while ((n = n.getParent()) != null) {
            if (!(n instanceof Tree)) continue;
            return (Tree)((Object)n);
        }
        return null;
    }

    public Treecol getTreecol() {
        List lcschs;
        int j;
        Treecols lcs;
        Tree tree = this.getTree();
        if (tree != null && (lcs = tree.getTreecols()) != null && (j = this.getColumnIndex()) < (lcschs = lcs.getChildren()).size()) {
            return (Treecol)((Object)lcschs.get(j));
        }
        return null;
    }

    public int getColumnIndex() {
        int j = 0;
        Iterator it = this.getParent().getChildren().iterator();
        while (it.hasNext() && it.next() != this) {
            ++j;
        }
        return j;
    }

    public int getMaxlength() {
        Tree tree = this.getTree();
        if (tree == null) {
            return 0;
        }
        Treecol lc = this.getTreecol();
        return lc != null ? lc.getMaxlength() : 0;
    }

    public int getLevel() {
        Component parent = this.getParent();
        return parent != null ? ((Treerow)parent).getLevel() : 0;
    }

    public String getColumnHtmlPrefix() {
        if (this.isFirstColumn()) {
            Treeitem item = this.getTreeitem();
            Tree tree = this.getTree();
            StringBuffer sb = new StringBuffer(80);
            if (tree != null && tree.isCheckmark()) {
                sb.append("<input type=\"").append(tree.isMultiple() ? "checkbox" : "radio").append('\"');
                if (item.isSelected()) {
                    sb.append(" checked=\"checked\"");
                }
                sb.append(" id=\"").append(this.getParent().getUuid()).append("!cm\" z:type=\"Tcfc\"/>");
            }
            Treeitem[] pitems = this.getTreeitems((Component)item);
            for (int j = 0; j < pitems.length; ++j) {
                this.appendImage(sb, j == 0 || this.isLastChild(pitems[j]) ? SPACER : VBAR, false);
            }
            if (item.isContainer()) {
                this.appendImage(sb, item.isOpen() ? (pitems.length == 0 ? ROOT_OPEN : (this.isLastChild(item) ? LAST_OPEN : TEE_OPEN)) : (pitems.length == 0 ? ROOT_CLOSE : (this.isLastChild(item) ? LAST_CLOSE : TEE_CLOSE)), true);
            } else {
                this.appendImage(sb, pitems.length == 0 ? SPACER : (this.isLastChild(item) ? LAST : TEE), false);
            }
            return sb.toString();
        }
        boolean empty = this.getImage() == null && this.getLabel().length() == 0 && this.getChildren().isEmpty();
        return empty ? "&nbsp;" : null;
    }

    public String getColumnHtmlPostfix() {
        Treeitem item = this.getTreeitem();
        Tree tree = this.getTree();
        if (tree != null && !tree.isCheckmark() && this.isFirstColumn() && item.isFocusRequired()) {
            return "<a href=\"javascript:;\" id=\"" + this.getParent().getUuid() + "!sel\" z:type=\"Tcfc\">  </a>";
        }
        return null;
    }

    private boolean isFirstColumn() {
        Component parent = this.getParent();
        return parent != null && parent.getChildren().get(0) == this;
    }

    public boolean isLastChild(Treeitem item) {
        Component parent = item.getParent();
        if (parent == null) {
            return true;
        }
        List sibs = parent.getChildren();
        return sibs.get(sibs.size() - 1) == item;
    }

    private Treeitem[] getTreeitems(Component item) {
        Component tch;
        LinkedList<Component> pitems = new LinkedList<Component>();
        while ((tch = item.getParent()) != null && (item = tch.getParent()) != null && !(item instanceof Tree)) {
            pitems.add(0, item);
        }
        return pitems.toArray(new Treeitem[pitems.size()]);
    }

    public Treeitem getTreeitem() {
        Component parent = this.getParent();
        return parent != null ? (Treeitem)parent.getParent() : null;
    }

    private void appendImage(StringBuffer sb, String name, boolean button) {
        Treeitem item;
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        String uri = this.getIconURI(name);
        sb.append("<img align=\"top\"");
        HTMLs.appendAttribute((StringBuffer)sb, (String)"src", (String)this.getDesktop().getExecution().encodeURL(uri));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"width", (int)width);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"height", (int)height);
        if (button && (item = this.getTreeitem()) != null) {
            sb.append(" z:type=\"Tcop\" id=\"").append(item.getTreerow().getUuid()).append("!open\"");
        }
        sb.append("/>");
    }

    private int getIconWidth() {
        return this.getRequiredIntInitParam("icon-width");
    }

    private int getIconHeight() {
        return this.getRequiredIntInitParam("icon-height");
    }

    private String getIconURI(String name) {
        String s = this.getInitParam("icon-uri");
        if (s == null) {
            throw new UiException("The icon-uri param must be defined");
        }
        return s + name;
    }

    private int getRequiredIntInitParam(String name) {
        int v = this.getIntInitParam(name);
        if (v <= 0) {
            throw new UiException("The " + name + " param must be defined and positive");
        }
        return v;
    }

    public String getWidth() {
        Treecol col = this.getTreecol();
        return col != null ? col.getWidth() : null;
    }

    public void setWidth(String width) {
        throw new UnsupportedOperationException("Set treecol's width instead");
    }

    public String getOuterAttrs() {
        Treecol col = this.getTreecol();
        String attrs = super.getOuterAttrs();
        return col != null ? attrs + col.getColAttrs() : attrs;
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Treerow)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.setParent(parent);
    }
}

