/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.impl.LabelImageElement;

public class Toolbarbutton
extends LabelImageElement {
    private String _orient = "horizontal";
    private String _dir = "normal";
    private String _href;
    private String _target;
    private int _tabindex = -1;

    public Toolbarbutton() {
    }

    public Toolbarbutton(String label) {
        this.setLabel(label);
    }

    public Toolbarbutton(String label, String image) {
        this.setLabel(label);
        this.setImage(image);
    }

    public String getDir() {
        return this._dir;
    }

    public void setDir(String dir) throws WrongValueException {
        if (!"normal".equals(dir) && !"reverse".equals(dir)) {
            throw new WrongValueException(dir);
        }
        if (!Objects.equals((Object)this._dir, (Object)dir)) {
            this._dir = dir;
            this.invalidate();
        }
    }

    public String getHref() {
        return this._href;
    }

    public void setHref(String href) throws WrongValueException {
        if (href != null && href.length() == 0) {
            href = null;
        }
        if (!Objects.equals((Object)this._href, (Object)href)) {
            this._href = href;
            this.invalidate();
        }
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.invalidate();
        }
    }

    public String getTarget() {
        return this._target;
    }

    public void setTarget(String target) {
        if (target != null && target.length() == 0) {
            target = null;
        }
        if (!Objects.equals((Object)this._target, (Object)target)) {
            this._target = target;
            this.smartUpdate("target", this._target);
        }
    }

    public int getTabindex() {
        return this._tabindex;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        if (this._tabindex != tabindex) {
            this._tabindex = tabindex;
            if (tabindex < 0) {
                this.smartUpdate("tabindex", null);
            } else {
                this.smartUpdate("tabindex", Integer.toString(this._tabindex));
            }
        }
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        this.appendAsapAttr(sb, "onFocus");
        this.appendAsapAttr(sb, "onBlur");
        this.appendAsapAttr(sb, "onRightClick");
        if (this._href == null) {
            sb.append(" href=\"javascript:;\"");
        } else {
            sb.append(" href=\"").append(this.getDesktop().getExecution().encodeURL(this._href)).append('\"');
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"target", (String)this._target);
        if (this._tabindex >= 0) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"tabindex", (int)this._tabindex);
        }
        return sb.toString();
    }
}

