/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Row;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.impl.XulElement;

public class Rows
extends XulElement {
    public Grid getGrid() {
        return (Grid)this.getParent();
    }

    public int getVisibleBegin() {
        Grid grid = this.getGrid();
        if (grid == null || !grid.inPagingMold()) {
            return 0;
        }
        Paginal pgi = grid.getPaginal();
        return pgi.getActivePage() * pgi.getPageSize();
    }

    public int getVisibleEnd() {
        Grid grid = this.getGrid();
        if (grid == null || !grid.inPagingMold()) {
            return Integer.MAX_VALUE;
        }
        Paginal pgi = grid.getPaginal();
        return (pgi.getActivePage() + 1) * pgi.getPageSize() - 1;
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Grid)) {
            throw new UiException("Unsupported parent for rows: " + parent);
        }
        boolean changed = this.getParent() != parent;
        super.setParent(parent);
        if (changed && parent != null) {
            ((Grid)parent).initAtClient();
        }
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Row)) {
            throw new UiException("Unsupported child for rows: " + child);
        }
        return super.insertBefore(child, insertBefore);
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        Grid grid = this.getGrid();
        if (grid != null) {
            grid.initAtClient();
            if (grid.inPagingMold()) {
                grid.getPaginal().setTotalSize(this.getChildren().size());
            }
        }
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        Grid grid = this.getGrid();
        if (grid != null) {
            grid.initAtClient();
            if (grid.inPagingMold()) {
                grid.getPaginal().setTotalSize(this.getChildren().size());
            }
        }
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Cropper {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Rows.this);
        }

        public boolean isCropper() {
            Grid grid = Rows.this.getGrid();
            return grid != null && grid.inPagingMold();
        }

        public Set getAvailableAtClient() {
            Grid grid = Rows.this.getGrid();
            if (grid == null || !grid.inPagingMold()) {
                return null;
            }
            HashSet avail = new HashSet(37);
            Paginal pgi = grid.getPaginal();
            int pgsz = pgi.getPageSize();
            int ofs = pgi.getActivePage() * pgsz;
            ListIterator it = Rows.this.getChildren().listIterator(ofs);
            while (--pgsz >= 0 && it.hasNext()) {
                avail.add(it.next());
            }
            return avail;
        }
    }
}

